package com.walker.support.milvus;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 数据集对象定义，写入数据时使用。
 * @author 时克英
 * @date 2022-08-23
 */
public class DataSet {

    private String tableName;
    private String partitionName;

    /** key = 字段名称，value = 字段值集合*/
    private Map<String, List<?>> fields = new HashMap<>();

    private String indexFieldName;  // 索引列的名称

    public String getIndexFieldName() {
        return indexFieldName;
    }

    public void setIndexFieldName(String indexFieldName) {
        this.indexFieldName = indexFieldName;
    }

    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getPartitionName() {
        return partitionName;
    }

    public void setPartitionName(String partitionName) {
        this.partitionName = partitionName;
    }

    public Map<String, List<?>> getFields() {
        return fields;
    }

    public void setFields(Map<String, List<?>> fields) {
        this.fields = fields;
    }

    public void addFieldList(String fieldName, List<?> data){
        List<?> list = this.fields.get(fieldName);
        if(list != null){
            throw new IllegalArgumentException(fieldName + "列已经设置数据，无需重复添加。");
        }
        this.fields.put(fieldName, data);
    }
}
