package com.walker.support.milvus;

public enum DataType {
    Float{
        public int getIndex(){
            return Float_VALUE;
        }
    },
    Double{
        public int getIndex(){
            return Double_VALUE;
        }
    },
    Integer{
        public int getIndex(){
            return Int32_VALUE;
        }
    },
    Long{
        public int getIndex(){
            return Int64_VALUE;
        }
    },
    String{
        public int getIndex(){
            return String_VALUE;
        }
    },
    FloatVector{
        public int getIndex(){
            return FloatVector_VALUE;
        }
    },
    BinaryVector{
        public int getIndex(){
           return BinaryVector_VALUE;
        }
    },
    None{
        public int getIndex(){
            return None_VALUE;
        }
    };

    public int getIndex(){
        throw new AbstractMethodError();
    }

    public static final DataType getType(int index){
        if(index == Float_VALUE){
            return Float;
        } else if(index == Double_VALUE){
            return Double;
        } else if(index == Int32_VALUE){
            return Integer;
        } else if(index == Int64_VALUE){
            return Long;
        } else if(index == String_VALUE){
            return String;
        } else if(index == FloatVector_VALUE){
            return FloatVector;
        } else if(index == BinaryVector_VALUE){
            return BinaryVector;
        } else if(index == None_VALUE){
            return None;
        } else {
            throw new IllegalArgumentException("不支持的数据格式：" + index);
        }
    }

    public static final int None_VALUE = 0;
//    public static final int Bool_VALUE = 1;
//    public static final int Int8_VALUE = 2;
//    public static final int Int16_VALUE = 3;
    public static final int Int32_VALUE = 4;
    public static final int Int64_VALUE = 5;
    public static final int Float_VALUE = 10;
    public static final int Double_VALUE = 11;
    public static final int String_VALUE = 20;
//    public static final int VarChar_VALUE = 21;
    public static final int BinaryVector_VALUE = 100;
    public static final int FloatVector_VALUE = 101;
}
