package com.walker.support.milvus;

/**
 * Milvus数据库操作服务定义。
 * @author 时克英
 * @date 2022-08-23
 */
public interface OperateService {

    boolean connect(String ip, int port);

    void close();

    /**
     * 创建一个表结构，在milvus内部是一个集合（Collection）
     * @param table
     */
    boolean createTable(Table table);

    /**
     * 删除一个表。
     * @param tableName
     */
    void dropTable(String tableName);

    /**
     * 写入一个数据集。
     * @param dataSet
     */
    boolean insertDataSet(DataSet dataSet);

    /**
     * 创建一个字段索引。
     * @param tableName 表名称
     * @param fieldName 要创建索引的字段名称
     * @param indexType 索引类型，参考：milvus索引类型字符串（IVF_FLAT/IVF_SQ8/IVF_PQ/HNSW/FLAT/ANNOY/等）
     * @param indexParam 索引参数，常用有："{\"nlist\":1024}"
     */
    boolean createIndex(String tableName, String fieldName, String indexType, String indexParam);

    /**
     * 删除已有的索引
     * @param tableName 表名称
     * @param fieldName 加索引的列名称，索引名称默认为:列名称 + '_index'，例如：book_intro_index
     */
    boolean dropIndex(String tableName, String fieldName);

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    //~ 以下为搜索方法相关
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    /**
     * 启动一个搜索，milvus搜索之前必须把表数据加载到内存中准备。
     * @param tableName 表名称
     */
    boolean prepareSearch(String tableName);

    /**
     * 按条件搜索。
     * @param query
     * @return
     */
    OutData searchVector(Query query);

    /**
     * 搜索后释放内存。在业务中数据变更后才需要释放重新加载，以提高效率。
     * @param tableName
     */
    void releaseSearch(String tableName);
}
