package com.walker.support.milvus;

import java.util.List;

public class Query {

    private String tableName;
    private String metricType;  // 矩阵类型，暂时固定值
    private String vectorName;

    private List<String> outFieldList = null;
    private List<List<Float>> searchVectors = null;

    private int topK = 10;
    private String searchParam = "{\"nprobe\":10}";

    private String fieldPrimaryKey; // 主键名称

    public String getFieldPrimaryKey() {
        return fieldPrimaryKey;
    }

    public void setFieldPrimaryKey(String fieldPrimaryKey) {
        this.fieldPrimaryKey = fieldPrimaryKey;
    }


    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getMetricType() {
        return metricType;
    }

    public void setMetricType(String metricType) {
        this.metricType = metricType;
    }

    public String getVectorName() {
        return vectorName;
    }

    public void setVectorName(String vectorName) {
        this.vectorName = vectorName;
    }

    public List<String> getOutFieldList() {
        return outFieldList;
    }

    public void setOutFieldList(List<String> outFieldList) {
        this.outFieldList = outFieldList;
    }

    public List<List<Float>> getSearchVectors() {
        return searchVectors;
    }

    public void setSearchVectors(List<List<Float>> searchVectors) {
        this.searchVectors = searchVectors;
    }

    public int getTopK() {
        return topK;
    }

    public void setTopK(int topK) {
        this.topK = topK;
    }

    public String getSearchParam() {
        return searchParam;
    }

    public void setSearchParam(String searchParam) {
        this.searchParam = searchParam;
    }

    @Override
    public String toString(){
        return new StringBuilder("[tableName=")
                .append(this.tableName).append(", vectorName=")
                .append(this.vectorName).append(", searchVectors=")
                .append(this.searchVectors).append("]").toString();
    }
}
