package com.walker.support.milvus.util;

import io.milvus.grpc.DataType;
import io.milvus.param.collection.FieldType;

public class FieldTypeUtils {

    public static FieldType toMilvusFieldType(com.walker.support.milvus.FieldType type, int dimension){
        FieldType.Builder builder = FieldType.newBuilder();
        builder.withName(type.getName())
                .withDescription(type.getDescription())
                .withAutoID(false)
                .withDimension(dimension)
                .withPrimaryKey(type.isPrimaryKey())
                .withTypeParams(type.getTypeParams())
                .withDataType(toMilvusDataType(type.getDataType()));
        return builder.build();
    }

    public static DataType toMilvusDataType(com.walker.support.milvus.DataType dt){
        if(dt == com.walker.support.milvus.DataType.String){
            return DataType.String;
        } else if(dt == com.walker.support.milvus.DataType.Float){
            return DataType.Float;
        } else if(dt == com.walker.support.milvus.DataType.Double){
            return DataType.Double;
        } else if(dt == com.walker.support.milvus.DataType.Integer){
            return DataType.Int32;
        } else if(dt == com.walker.support.milvus.DataType.Long){
            return DataType.Int64;
        } else if(dt == com.walker.support.milvus.DataType.FloatVector){
            return DataType.FloatVector;
        } else if(dt == com.walker.support.milvus.DataType.BinaryVector){
            return DataType.BinaryVector;
        } else if(dt == com.walker.support.milvus.DataType.None){
            return DataType.None;
        } else {
            throw new IllegalArgumentException("咱未实现其他字段格式支持：" + dt.name());
        }
    }
}
