/*
 * Decompiled with CFR 0.152.
 */
package com.walker.support.milvus;

import com.walker.support.milvus.DataType;
import com.walker.support.milvus.ParamException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class FieldType {
    private String name;
    private boolean primaryKey;
    private String description;
    private DataType dataType;
    private Map<String, String> typeParams;

    private FieldType(Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.name = builder.name;
        this.primaryKey = builder.primaryKey;
        this.description = builder.description;
        this.dataType = builder.dataType;
        this.typeParams = builder.typeParams;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "[name=" + this.name + ", isPrimary=" + this.primaryKey + ", dataType=" + (Object)((Object)this.dataType) + ", summary=" + this.description + "]";
    }

    public String getName() {
        return this.name;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public String getDescription() {
        return this.description;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public Map<String, String> getTypeParams() {
        return this.typeParams;
    }

    public static final class Builder {
        private String name;
        private boolean primaryKey = false;
        private String description = "";
        private DataType dataType;
        private final Map<String, String> typeParams = new HashMap<String, String>();

        private Builder() {
        }

        public Builder withName(String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public Builder withPrimaryKey(boolean primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public Builder withDescription(String description) {
            if (description == null) {
                throw new NullPointerException("description is marked non-null but is null");
            }
            this.description = description;
            return this;
        }

        public Builder withDataType(DataType dataType) {
            if (dataType == null) {
                throw new NullPointerException("dataType is marked non-null but is null");
            }
            this.dataType = dataType;
            return this;
        }

        public Builder addTypeParam(String key, String value) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.typeParams.put(key, value);
            return this;
        }

        public Builder withTypeParams(Map<String, String> typeParams) {
            if (typeParams == null) {
                throw new NullPointerException("typeParams is marked non-null but is null");
            }
            Map<String, String> var10001 = this.typeParams;
            typeParams.forEach(var10001::put);
            return this;
        }

        public Builder withDimension(Integer dimension) {
            if (dimension == null) {
                throw new NullPointerException("dimension is marked non-null but is null");
            }
            this.typeParams.put("dim", dimension.toString());
            return this;
        }

        public Builder withMaxLength(Integer maxLength) {
            if (maxLength == null) {
                throw new NullPointerException("maxLength is marked non-null but is null");
            }
            this.typeParams.put("max_length", maxLength.toString());
            return this;
        }

        public FieldType build() throws ParamException {
            if (this.name == null || StringUtils.isBlank((CharSequence)this.name)) {
                throw new ParamException(this.name + " cannot be null or empty");
            }
            if (this.dataType != null && this.dataType != DataType.None) {
                if (this.dataType == DataType.String) {
                    throw new ParamException("String type is not supported, use VarChar instead");
                }
                if (this.dataType == DataType.FloatVector || this.dataType == DataType.BinaryVector) {
                    if (!this.typeParams.containsKey("dim")) {
                        throw new ParamException("Vector field dimension must be specified");
                    }
                    try {
                        int len = Integer.parseInt(this.typeParams.get("dim"));
                        if (len <= 0) {
                            throw new ParamException("Vector field dimension must be larger than zero");
                        }
                    }
                    catch (NumberFormatException var3) {
                        throw new ParamException("Vector field dimension must be an integer number");
                    }
                }
                return new FieldType(this);
            }
            throw new ParamException("Field data type is illegal");
        }
    }
}

