/*
 * Decompiled with CFR 0.152.
 */
package com.walker.support.milvus;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutData {
    private final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<Long, Float> idScoreMap = new HashMap<Long, Float>();
    private List<Long> keyList = new ArrayList<Long>();
    private List<Long> businessIdList = new ArrayList<Long>();

    public float getScoreByKey(long key) {
        Float score = this.idScoreMap.get(key);
        if (score == null) {
            System.out.println("key\u5bf9\u5e94\u5206\u503c\u4e0d\u5b58\u5728\uff0ckey = " + key);
            return 0.0f;
        }
        return score.floatValue();
    }

    public List<Data> getResultList() {
        if (this.keyList == null || this.keyList.size() == 0) {
            this.logger.error("keyList \u4e3a\u7a7a");
            return null;
        }
        if (this.businessIdList == null || this.businessIdList.size() == 0) {
            System.out.println("businessIdList \u4e3a\u7a7a");
            return null;
        }
        if (this.keyList.size() != this.businessIdList.size()) {
            this.logger.error("businessIdList \u4e0e keyList \u5927\u5c0f\u4e0d\u4e00\u81f4!");
            return null;
        }
        ArrayList<Data> resultList = new ArrayList<Data>();
        Data d = null;
        float oneScore = 0.0f;
        for (int i = 0; i < this.keyList.size(); ++i) {
            oneScore = this.getScoreByKey(this.keyList.get(i));
            d = new Data(this.keyList.get(i), this.businessIdList.get(i), oneScore);
            resultList.add(d);
            this.logger.debug(d.toString());
        }
        return resultList;
    }

    public Map<Long, Float> getIdScoreMap() {
        return this.idScoreMap;
    }

    public void setIdScoreMap(Map<Long, Float> idScoreMap) {
        this.idScoreMap = idScoreMap;
    }

    public List<Long> getKeyList() {
        return this.keyList;
    }

    public void setKeyList(List<Long> keyList) {
        this.keyList = keyList;
    }

    public List<Long> getBusinessIdList() {
        return this.businessIdList;
    }

    public void setBusinessIdList(List<Long> businessIdList) {
        this.businessIdList = businessIdList;
    }

    public void addIdScore(long id, float score) {
        this.idScoreMap.put(id, Float.valueOf(score));
    }

    public static class Data
    implements Serializable {
        private long key;
        private long businessId;
        private float score = 0.0f;

        public long getKey() {
            return this.key;
        }

        public long getBusinessId() {
            return this.businessId;
        }

        public float getScore() {
            return this.score;
        }

        public Data(long key, long businessId, float score) {
            this.key = key;
            this.businessId = businessId;
            this.score = score;
        }

        public String toString() {
            return "[key=" + this.key + ", businessId=" + this.businessId + ", score=" + this.score + "]";
        }
    }
}

