/*
 * Decompiled with CFR 0.152.
 */
package com.walker.support.milvus.engine;

import com.walker.support.milvus.DataSet;
import com.walker.support.milvus.FieldType;
import com.walker.support.milvus.OperateService;
import com.walker.support.milvus.OutData;
import com.walker.support.milvus.Query;
import com.walker.support.milvus.Table;
import com.walker.support.milvus.util.FieldTypeUtils;
import io.milvus.client.MilvusServiceClient;
import io.milvus.grpc.SearchResults;
import io.milvus.param.ConnectParam;
import io.milvus.param.IndexType;
import io.milvus.param.MetricType;
import io.milvus.param.R;
import io.milvus.param.RpcStatus;
import io.milvus.param.collection.CreateCollectionParam;
import io.milvus.param.collection.DropCollectionParam;
import io.milvus.param.collection.LoadCollectionParam;
import io.milvus.param.collection.ReleaseCollectionParam;
import io.milvus.param.dml.InsertParam;
import io.milvus.param.dml.SearchParam;
import io.milvus.param.index.CreateIndexParam;
import io.milvus.param.index.DropIndexParam;
import io.milvus.response.SearchResultsWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOperateService
implements OperateService {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private MilvusServiceClient client = null;

    @Override
    public boolean connect(String ip, int port) {
        if (this.client != null) {
            this.client.close();
            this.logger.warn("MilvusServiceClient\u5728\u8fd0\u884c\uff0c\u6b63\u5728\u505c\u6b62\uff0c\u51c6\u5907\u521b\u5efa\u65b0\u5bf9\u8c61: " + ip + ", " + port);
        }
        try {
            this.client = new MilvusServiceClient(ConnectParam.newBuilder().withHost(ip).withPort(port).build());
            return true;
        }
        catch (Exception ex) {
            this.logger.error("\u521b\u5efa MilvusServiceClient \u9519\u8bef\uff1a" + ip, (Throwable)ex);
            return false;
        }
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }

    @Override
    public boolean createTable(Table table) {
        this.checkConnection();
        if (table == null) {
            this.logger.error("table \u5fc5\u987b\u63d0\u4f9b");
            return false;
        }
        List<FieldType> fieldList = table.getFieldTypes();
        if (fieldList == null || fieldList.size() == 0) {
            this.logger.error("\u672a\u627e\u5230\u4efb\u4f55\u5b57\u6bb5\u4fe1\u606f");
            return false;
        }
        String tableName = table.getCollectionName();
        if (tableName == null || tableName.equals("")) {
            this.logger.error("\u8868\u540d\u5fc5\u987b\u63d0\u4f9b\uff1atableName");
            return false;
        }
        try {
            ArrayList<io.milvus.param.collection.FieldType> milvusFieldList = new ArrayList<io.milvus.param.collection.FieldType>();
            for (FieldType ft : fieldList) {
                milvusFieldList.add(FieldTypeUtils.toMilvusFieldType(ft, table.getDimension()));
            }
            CreateCollectionParam.Builder builder = CreateCollectionParam.newBuilder();
            CreateCollectionParam param = builder.withCollectionName(tableName).withDescription(table.getDescription()).withShardsNum(table.getShardsNum()).withFieldTypes(milvusFieldList).build();
            R statusR = this.client.createCollection(param);
            return this.checkStatusR((R<RpcStatus>)statusR);
        }
        catch (Exception ex) {
            this.logger.error("\u521b\u5efa\u5411\u91cf\u8868\u5931\u8d25\uff1a" + tableName, (Throwable)ex);
            return false;
        }
    }

    @Override
    public void dropTable(String tableName) {
        this.checkConnection();
        if (tableName == null || tableName.equals("")) {
            this.logger.error("\u8868\u540d\u5fc5\u987b\u63d0\u4f9b\uff1atableName");
            return;
        }
        this.client.dropCollection(DropCollectionParam.newBuilder().withCollectionName(tableName).build());
    }

    @Override
    public boolean insertDataSet(DataSet dataSet) {
        this.checkConnection();
        if (dataSet == null) {
            return false;
        }
        String tableName = dataSet.getTableName();
        if (tableName == null || tableName.equals("")) {
            this.logger.error("\u8868\u540d\u5fc5\u987b\u63d0\u4f9b\uff1atableName");
            return false;
        }
        Map<String, List<?>> fields = dataSet.getFields();
        if (fields == null || fields.size() == 0) {
            this.logger.error("\u6570\u636e\u96c6\u5408\u5fc5\u987b\u63d0\u4f9b\uff1afields");
            return false;
        }
        ArrayList<InsertParam.Field> fieldList = new ArrayList<InsertParam.Field>();
        for (Map.Entry<String, List<?>> entry : fields.entrySet()) {
            fieldList.add(new InsertParam.Field(entry.getKey(), entry.getValue()));
        }
        InsertParam.Builder builder = InsertParam.newBuilder();
        builder.withCollectionName(dataSet.getTableName());
        if (dataSet.getPartitionName() != null && !dataSet.getPartitionName().equals("")) {
            builder.withPartitionName(dataSet.getPartitionName());
        }
        builder.withFields(fieldList);
        InsertParam insertParam = builder.build();
        R statusR = this.client.insert(insertParam);
        if (statusR == null) {
            return false;
        }
        if (statusR.getStatus().intValue() == R.Status.Success.getCode()) {
            this.logger.error("insert \u8fd4\u56de\u503c\uff1a" + statusR.getStatus());
            return true;
        }
        return false;
    }

    @Override
    public boolean createIndex(String tableName, String fieldName, String indexType, String indexParam) {
        this.checkConnection();
        IndexType INDEX_TYPE = null;
        if (indexType.equals("IVF_FLAT")) {
            INDEX_TYPE = IndexType.IVF_FLAT;
        } else if (indexType.equals("IVF_SQ8")) {
            INDEX_TYPE = IndexType.IVF_SQ8;
        } else if (indexType.equals("IVF_PQ")) {
            INDEX_TYPE = IndexType.IVF_PQ;
        } else if (indexType.equals("HNSW")) {
            INDEX_TYPE = IndexType.HNSW;
        } else if (indexType.equals("ANNOY")) {
            INDEX_TYPE = IndexType.ANNOY;
        } else if (indexType.equals("FLAT")) {
            INDEX_TYPE = IndexType.FLAT;
        } else {
            throw new IllegalArgumentException("\u6682\u4e0d\u652f\u6301\u5176\u4ed6\u7d22\u5f15\u7c7b\u578b\uff1a" + indexType);
        }
        CreateIndexParam.Builder builder = CreateIndexParam.newBuilder();
        builder.withCollectionName(tableName).withFieldName(fieldName).withIndexName(fieldName + "_index").withIndexType(INDEX_TYPE).withMetricType(MetricType.L2).withExtraParam(indexParam).withSyncMode(Boolean.valueOf(false));
        R statusR = this.client.createIndex(builder.build());
        return this.checkStatusR((R<RpcStatus>)statusR);
    }

    @Override
    public boolean dropIndex(String tableName, String fieldName) {
        this.checkConnection();
        R statusR = this.client.dropIndex(DropIndexParam.newBuilder().withCollectionName(tableName).withIndexName(fieldName + "_index").build());
        return this.checkStatusR((R<RpcStatus>)statusR);
    }

    @Override
    public boolean prepareSearch(String tableName) {
        this.checkConnection();
        R statusR = this.client.loadCollection(LoadCollectionParam.newBuilder().withCollectionName(tableName).build());
        return this.checkStatusR((R<RpcStatus>)statusR);
    }

    @Override
    public OutData searchVector(Query query) {
        SearchParam searchParam;
        R respSearch;
        this.checkConnection();
        List<List<Float>> search_vectors = query.getSearchVectors();
        if (search_vectors == null) {
            this.logger.error("\u672a\u8bbe\u7f6e\u641c\u7d22\u5411\u91cf\u6761\u4ef6\uff1asearch_vectors");
            return null;
        }
        String vectorField = query.getVectorName();
        if (vectorField == null || vectorField.equals("")) {
            this.logger.error("\u672a\u8bbe\u7f6e\u641c\u7d22\u5b57\u6bb5\u540d\u79f0\uff1avectorField");
            return null;
        }
        List<String> outputFieldList = query.getOutFieldList();
        if (outputFieldList == null || outputFieldList.size() == 0) {
            this.logger.error("\u672a\u8bbe\u7f6e\u8f93\u51fa\u5b57\u6bb5\u540d\u79f0\uff1aOutFieldList");
            return null;
        }
        MetricType metricType = null;
        if (query.getMetricType() == null || query.getMetricType().equals("")) {
            metricType = MetricType.L2;
        }
        if ((respSearch = this.client.search(searchParam = SearchParam.newBuilder().withCollectionName(query.getTableName()).withMetricType(metricType).withOutFields(outputFieldList).withTopK(Integer.valueOf(query.getTopK())).withVectors(query.getSearchVectors()).withVectorFieldName(query.getVectorName()).withParams(query.getSearchParam()).build())) == null) {
            this.logger.warn("\u672a\u641c\u7d22\u5230\u76f8\u4f3c\u7ed3\u679c\u5bf9\u8c61\uff1a" + query);
            return null;
        }
        SearchResultsWrapper wrapperSearch = new SearchResultsWrapper(((SearchResults)respSearch.getData()).getResults());
        System.out.println(wrapperSearch.getIDScore(0));
        OutData outData = new OutData();
        List scoreList = wrapperSearch.getIDScore(0);
        if (scoreList != null && scoreList.size() > 0) {
            for (SearchResultsWrapper.IDScore idScore : scoreList) {
                outData.addIdScore(idScore.getLongID(), idScore.getScore());
            }
        }
        for (String outField : outputFieldList) {
            if (outField.equals("id")) {
                outData.setKeyList(wrapperSearch.getFieldData("id", 0));
                continue;
            }
            outData.setBusinessIdList(wrapperSearch.getFieldData(outField, 0));
        }
        return outData;
    }

    @Override
    public void releaseSearch(String tableName) {
        this.checkConnection();
        this.client.releaseCollection(ReleaseCollectionParam.newBuilder().withCollectionName(tableName).build());
    }

    private void checkConnection() {
        if (this.client == null) {
            throw new RuntimeException("\u670d\u52a1\u672a\u8fde\u63a5\uff0c\u8bf7\u5148\u8fde\u63a5 milvus \u670d\u52a1");
        }
    }

    private boolean checkStatusR(R<RpcStatus> statusR) {
        if (statusR == null) {
            return false;
        }
        return statusR.getStatus().intValue() == R.Status.Success.getCode();
    }
}

