/*
 * Decompiled with CFR 0.152.
 */
package com.walker.support.redis.cache;

import com.walker.cache.AbstractCacheProvider;
import com.walker.cache.Cache;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.support.redis.RedisHelper;
import com.walker.support.redis.cache.RedisCache;
import java.util.Map;

public abstract class RedisCacheProvider<T>
extends AbstractCacheProvider<T> {
    private RedisHelper redisHelper;

    public void setRedisHelper(RedisHelper redisHelper) {
        this.redisHelper = redisHelper;
    }

    protected Cache provideCacheInstance(String name, Map<String, String> param) {
        if (this.isUseRedis()) {
            RedisCache cache = new RedisCache(name, param);
            cache.setRedisHelper(this.redisHelper);
            return cache;
        }
        return super.provideCacheInstance(name, param);
    }

    public void destroy() throws Exception {
        if (!this.isUseRedis()) {
            super.destroy();
        }
    }

    protected int loadDataToCache(Cache cache) {
        return 0;
    }

    public T getCacheData(String key) {
        if (this.isUseRedis()) {
            return (T)this.getRedisCache().get(key, this.getProviderType());
        }
        return (T)super.getCacheData(key);
    }

    protected RedisCache getRedisCache() {
        return (RedisCache)this.getCache();
    }

    public long getCacheCount() {
        if (this.isUseRedis()) {
            return this.getRedisCache().getPersistentSize();
        }
        return super.getCacheCount();
    }

    public void removeCacheData(String key) {
        if (this.isUseRedis()) {
            this.getRedisCache().remove(key);
        } else {
            super.removeCacheData(key);
        }
    }

    public void updateCacheData(String key, T data) {
        if (this.isUseRedis()) {
            this.getRedisCache().replace(key, data);
        } else {
            super.updateCacheData(key, data);
        }
    }

    public void putCacheData(String key, T data) {
        if (this.isUseRedis()) {
            this.getRedisCache().put(key, data);
        } else {
            super.putCacheData(key, data);
        }
    }

    public void putCacheData(String key, T data, long expiredSeconds) {
        assert (StringUtils.isNotEmpty((String)key));
        assert (data != null);
        assert (expiredSeconds > 0L);
        if (this.isUseRedis()) {
            this.getRedisCache().put(key, data, expiredSeconds);
        } else {
            super.putCacheData(key, data, expiredSeconds);
        }
    }

    public void reload() throws Exception {
        if (this.isUseRedis()) {
            super.reload();
        } else {
            super.reload();
        }
    }

    public String getRedisRootData(String key) {
        return this.getRedisCache().getRootData(key);
    }
}

