/*
 * Decompiled with CFR 0.152.
 */
package com.walker.support.redis.cache;

import com.walker.cache.Cache;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.support.redis.cache.RedisCacheProvider;
import java.util.List;

public abstract class RedisListCacheProvider<T>
extends RedisCacheProvider<T> {
    @Override
    protected int loadDataToCache(Cache cache) {
        logger.info("\u57fa\u4e8e\u96c6\u5408\u7684Redis\u7f13\u5b58\uff0c\u4e0d\u652f\u6301\u521d\u59cb\u5316\u52a0\u8f7d\u7f13\u5b58\u6570\u636e\u3002");
        return 0;
    }

    @Override
    public T getCacheData(String key) {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff0c\u8bf7\u8c03\u7528\uff1agetCacheList()");
    }

    @Override
    public long getCacheCount() {
        return 0L;
    }

    @Override
    public void removeCacheData(String key) {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff0c\u8bf7\u8c03\u7528\uff1aremoveList()");
    }

    @Override
    public void updateCacheData(String key, T data) {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u66f4\u65b0\u96c6\u5408\u65b9\u6cd5\uff0c\u8bf7\u5148\u5220\u9664\u8001\u6570\u636e\u518d\u6dfb\u52a0");
    }

    @Override
    public void putCacheData(String key, T data) {
        this.putCacheData(key, data, 0L);
    }

    @Override
    public void putCacheData(String key, T data, long expiredSeconds) {
        this.checkKey(key, data);
        this.getRedisCache().putListAppend(key, data);
    }

    public void putCacheList(String key, List<T> data) {
        this.putCacheList(key, data, 0L);
    }

    public void putCacheList(String key, List<T> data, long expiredSeconds) {
        if (StringUtils.isEmptyList(data)) {
            throw new IllegalArgumentException("list is required!");
        }
        if (StringUtils.isEmpty((String)key)) {
            throw new IllegalArgumentException("key is required!");
        }
        this.getRedisCache().putList(key, data, expiredSeconds);
    }

    public void putCacheListAppend(String key, T data) {
        this.checkKey(key, data);
        this.getRedisCache().putListAppend(key, data);
    }

    private void checkKey(String key, T data) {
        if (data == null) {
            throw new IllegalArgumentException("data is required!");
        }
        if (StringUtils.isEmpty((String)key)) {
            throw new IllegalArgumentException("key is required!");
        }
    }

    public List<T> getCacheList(String key) {
        if (StringUtils.isEmpty((String)key)) {
            throw new IllegalArgumentException("key is required!");
        }
        return this.getRedisCache().getList(key, 0L, -1L, this.getProviderType());
    }

    public void removeCacheList(String key, T data) {
        this.getRedisCache().removeList(key, data);
    }

    public void removeCacheList(String key) {
        this.getRedisCache().removeList(key);
    }
}

