package com.walker.support.redis.cache;

import com.walker.db.page.GenericPager;
import com.walker.db.page.ListPageContext;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 描述：redis带分页的缓存对象
 * @author 时克英
 * @date 2017年2月10日 上午9:01:58
 */

public class RedisPageCache extends RedisCache {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1918144861581384722L;
	
	private String nameKeySet = null;

	public RedisPageCache(String providerName, Map<String, String> param){
		super(providerName, param);
		nameKeySet = this.getCacheName() + "set";
	}
	
	/**
	 * 为分页缓存对象，添加一个缓存
	 * @param score 排序值，例如：时间、数值等
	 * @param id 对象唯一id
	 * @param data 存储数据字符串
	 */
	public void putSort(double score, String id, String data){
//		Jedis jedis = null;
		try{
//			jedis = this.getRedis();
	//				jedis.zadd(key, scoreMembers);
	//				jedis.zrange(key, start, end);
			// 存储缓存的分页集合引用
//			jedis.zadd(nameKeySet, score, id);
			this.getRedisHelper().sortSetAdd(nameKeySet, id, score);
			// 存储缓存实际数据
//			jedis.hset(getCacheName(), id, data);
			this.getRedisHelper().hset(getCacheName(), id, data);
			
		} catch(Exception e){
			logger.error("putSort 异常：" + id, e);
		}
	}
	
	/**
	 * 为分页缓存对象，删除一个缓存
	 * @param id 缓存对象唯一id
	 */
	public void removeSort(String id){
//		Jedis jedis = null;
		try{
//			jedis = this.getRedis();
//			jedis.zrem(nameKeySet, id);
//			jedis.hdel(getCacheName(), id);
			this.getRedisHelper().sortSetRemove(nameKeySet, id);
			this.getRedisHelper().hdel(getCacheName(), id);
			
		} catch(Exception e){
			logger.error("removeSort 异常：" + id, e);
		}
	}
	
	/**
	 * 为分页缓存对象，返回一页数据集合
	 * @param pageIndex 页码数，从1开始
	 * @param pageSize 每页数量
	 * @return
	 */
	public GenericPager<Object> queryListPage(int pageIndex, int pageSize){
//		Jedis jedis = null;
		try{
//			jedis = this.getRedis();
//			Long sizeObj = jedis.hlen(getCacheName());
			Long sizeObj = this.getRedisHelper().hSize(getCacheName());
			GenericPager<Object> pager = ListPageContext.createGenericPager((List<Object>)null
					, pageIndex, pageSize, sizeObj==null?0:sizeObj.intValue());
			int startIndex = (int)pager.getFirstRowIndexInPage();
			// 通过索引集合找到需要的数据引用
//			Set<String> dataSet = jedis.zrevrange(nameKeySet, startIndex, (startIndex+pageSize-1));
			Set<Object> dataSet = this.getRedisHelper().sortSetRange(nameKeySet, startIndex, (startIndex+pageSize-1));
			if(dataSet != null && dataSet.size() > 0){
				// 根据索引得到实际缓存数据（hashmap中）
				logger.debug(dataSet.toString());
				String[] arrayString = new String[dataSet.size()];
//				pager.setDatas(jedis.hmget(this.getCacheName(), dataSet.toArray(arrayString)));
				pager.setDatas(this.getRedisHelper().hmGetList(getCacheName(), dataSet));
				;
			}
			return pager;
			
		} catch(Exception e){
			logger.error("queryListPage 异常：" + this.getCacheName(), e);
			return null;
		}
	}
	
	/**
	 * 返回给定限制的缓存数据集合
	 * @param maxSize 限制的最大数量
	 * @return
	 */
	@Override
	public Collection<Object> queryListLimit(int maxSize){
		if(maxSize < 0 || maxSize >=Integer.MAX_VALUE){
			return null;
		}
		
		try{
			long cacheSize = 0;
//			Long result = jedis.hlen(getCacheName());
			Long result = this.getRedisHelper().hSize(getCacheName());
			if(result != null){
				cacheSize = result.longValue();
			}
			
			// 要返获取的数量
			long mySize = 0;
			if(cacheSize <= maxSize){
				mySize = cacheSize;
			} else {
				mySize = maxSize;
			}
			if(mySize <= 0){
				return null;
			}
			
//			Set<String> dataSet = jedis.zrevrange(nameKeySet, 0, mySize-1);
			Set<Object> dataSet = this.getRedisHelper().sortSetRange(nameKeySet, 0, mySize-1);
			if(dataSet != null){
				// 根据索引得到实际缓存数据（hashmap中）
				String[] arrayString = new String[dataSet.size()];
//				return jedis.hmget(this.getCacheName(), dataSet.toArray(arrayString));
				return this.getRedisHelper().hmGetList(this.getCacheName(), dataSet);
			} else {
				return null;
			}
			
		} catch(Exception e){
			logger.error("queryListLimit 异常：" + this.getCacheName(), e);
		}
		return null;
	}
	
	@Override
	public void replace(String key, Object data) {
//		Jedis jedis = null;
		try{
//			jedis = this.getRedis();
//			jedis.hset(getCacheName(), key, data.toString());
			this.getRedisHelper().hset(getCacheName(), key, data);
			
		} catch(Exception e){
			logger.error("replace 异常：" + key + ", " + data, e);
		}
	}
	
	@Override
	public void put(String key, Object data) {
		throw new UnsupportedOperationException("不支持的方法：分页缓存中，不能直接调用put方法");
	}
	
}
