/*
 * Decompiled with CFR 0.152.
 */
package com.walker.support.redis.cache;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.walker.cache.Cachable;
import com.walker.cache.Cache;
import com.walker.cache.CacheConfig;
import com.walker.cache.CacheOperateListener;
import com.walker.cache.util.KeyUtils;
import com.walker.infrastructure.ApplicationRuntimeException;
import com.walker.infrastructure.core.ApplicationBeanDestroied;
import com.walker.infrastructure.core.ApplicationBeanInitialized;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.support.redis.RedisHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisCache
implements Cache,
ApplicationBeanInitialized,
ApplicationBeanDestroied {
    private static final long serialVersionUID = -2870330465438805899L;
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private String cacheName;
    CacheOperateListener cacheOperateListener = null;
    boolean hasCacheListener = false;
    private RedisHelper redisHelper;
    private String nameKeySet = null;
    private boolean supportExpiredCache = false;

    public boolean isSupportExpiredCache() {
        return this.supportExpiredCache;
    }

    public void setSupportExpiredCache(boolean supportExpiredCache) {
        this.supportExpiredCache = supportExpiredCache;
    }

    public RedisHelper getRedisHelper() {
        return this.redisHelper;
    }

    public void setRedisHelper(RedisHelper redisHelper) {
        this.redisHelper = redisHelper;
    }

    public RedisCache(String providerName, Map<String, String> param) {
        this.setCacheName(providerName);
        this.nameKeySet = this.getCacheName() + ":set";
    }

    public void shutdown() {
    }

    public void startup() {
    }

    private void checkSupportExpired() {
        if (!this.supportExpiredCache) {
            throw new IllegalCallerException("\u8be5\u7f13\u5b58'" + this.getCacheName() + "'\u4e0d\u652f\u6301\u7f13\u5b58\u5931\u6548\uff0c\u8bf7\u8c03\u7528\u4e0d\u5e26\u65f6\u95f4\u53c2\u6570\u65b9\u6cd5\uff01\u5982\u679c\u9700\u8981\u5931\u6548\u8bf7\u8c03\u7528\u65b9\u6cd5\uff1asetSupportExpiredCache(true)");
        }
    }

    private void checkNotSupportExpired() {
        if (this.supportExpiredCache) {
            throw new IllegalCallerException("\u8be5\u7f13\u5b58\u652f\u6301\u65f6\u95f4\u5931\u6548\uff08supportExpiredCache = true\uff09\uff0c\u8bf7\u8c03\u7528\u5e26\u65f6\u95f4\u53c2\u6570\u7684\u65b9\u6cd5\uff1aput(String key, Object data, long expiredSeconds)");
        }
    }

    public void put(String key, Object data) {
        this.checkNotSupportExpired();
        try {
            if (data instanceof String) {
                this.redisHelper.hset(this.getCacheName(), key, data.toString());
            } else {
                this.redisHelper.hset(this.getCacheName(), key, JsonUtils.objectToJsonString((Object)data));
            }
            if (this.hasCacheListener) {
                this.cacheOperateListener.onPut(data);
            }
        }
        catch (Exception e) {
            if (e instanceof JsonMappingException) {
                this.logger.error("JsonMappingException: " + key + ", data=" + data.toString(), (Throwable)e);
            }
            if (e instanceof JsonProcessingException) {
                this.logger.error("JsonProcessingException: " + key + ", data=" + data.toString(), (Throwable)e);
            }
            e.printStackTrace();
        }
    }

    public void put(String key, Object data, long expiredSeconds) {
        this.checkSupportExpired();
        try {
            if (data instanceof String) {
                this.redisHelper.set(this.acquireListKey(key), data.toString(), expiredSeconds);
            } else {
                this.redisHelper.set(this.acquireListKey(key), JsonUtils.objectToJsonString((Object)data), expiredSeconds);
            }
            if (this.hasCacheListener) {
                this.cacheOperateListener.onPut(data);
            }
        }
        catch (Exception e) {
            if (e instanceof JsonMappingException) {
                this.logger.error("JsonMappingException: " + key + ", data=" + data.toString(), (Throwable)e);
            }
            if (e instanceof JsonProcessingException) {
                this.logger.error("JsonProcessingException: " + key + ", data=" + data.toString(), (Throwable)e);
            }
            e.printStackTrace();
        }
    }

    private String acquireListKey(String key) {
        return KeyUtils.acquireListKey((String)this.getCacheName(), (String)key);
    }

    public void putList(String key, List<Object> list, long expiredSeconds) {
        if (expiredSeconds > 0L) {
            this.checkSupportExpired();
        }
        Object tmp = null;
        try {
            Iterator<Object> iterator = list.iterator();
            while (iterator.hasNext()) {
                Object data;
                tmp = data = iterator.next();
                if (data instanceof String) {
                    this.redisHelper.lSet(this.acquireListKey(key), data.toString(), expiredSeconds);
                    continue;
                }
                this.redisHelper.lSet(this.acquireListKey(key), JsonUtils.objectToJsonString((Object)data), expiredSeconds);
            }
            tmp = JsonUtils.objectToJsonString(list);
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("redis\u7f13\u5b58\u64cd\u4f5c\u5931\u8d25\uff0ckey = " + key + ", data=" + tmp, (Throwable)e);
        }
    }

    public void putListAppend(String key, Object data) {
        if (data instanceof String) {
            this.redisHelper.lSet(this.acquireListKey(key), data.toString());
        } else {
            try {
                this.redisHelper.lSet(this.acquireListKey(key), JsonUtils.objectToJsonString((Object)data));
            }
            catch (Exception e) {
                throw new RuntimeException("redis\u7f13\u5b58\u64cd\u4f5c\u5931\u8d25\uff0ckey = " + key + "putListAppend = " + data, e);
            }
        }
    }

    public List<Object> getList(String key, long start, long end, Class<?> clazz) {
        List<Object> list = this.redisHelper.lGet(this.acquireListKey(key), start, end);
        if (list == null || list.size() == 0) {
            return null;
        }
        ArrayList<Object> resultList = new ArrayList<Object>();
        try {
            Object javaObj = null;
            for (Object obj : list) {
                javaObj = JsonUtils.jsonStringToObject((String)obj.toString(), clazz);
                resultList.add(javaObj);
            }
            return resultList;
        }
        catch (Exception ex) {
            throw new RuntimeException("getList\u83b7\u53d6\u7f13\u5b58\u96c6\u5408\u9519\u8bef\uff1a" + ex.getMessage(), ex);
        }
    }

    public void removeList(String key, Object value) {
        String data = null;
        if (value instanceof String) {
            data = value.toString();
        } else {
            try {
                data = JsonUtils.objectToJsonString((Object)value);
            }
            catch (Exception e) {
                throw new RuntimeException("removeList\u9519\u8bef\uff1a" + e.getMessage() + ", value = " + value, e);
            }
        }
        this.redisHelper.lRemove(this.acquireListKey(key), 0L, data);
    }

    public void removeList(String key) {
        this.redisHelper.removeList(this.acquireListKey(key));
    }

    public long getListSize(String key) {
        return this.redisHelper.lGetListSize(this.acquireListKey(key));
    }

    public Object remove(String key) {
        try {
            if (this.supportExpiredCache) {
                this.redisHelper.del(this.acquireListKey(key));
            } else {
                this.redisHelper.hdel(this.getCacheName(), key);
            }
        }
        catch (Exception e) {
            this.logger.error("\u7f13\u5b58 remove \u9519\u8bef\uff1a" + key, (Throwable)e);
        }
        return null;
    }

    public void remove(List<String> keys) {
        if (keys != null) {
            try {
                if (this.supportExpiredCache) {
                    this.redisHelper.del(StringUtils.toStringArray(keys));
                } else {
                    this.redisHelper.hdel(this.getCacheName(), keys);
                }
            }
            catch (Exception e) {
                this.logger.error("\u7f13\u5b58\u6279\u91cf remove \u9519\u8bef\uff1a" + keys, (Throwable)e);
            }
        }
    }

    public long getPersistentSize() {
        try {
            if (this.supportExpiredCache) {
                return 0L;
            }
            return this.redisHelper.hSize(this.getCacheName());
        }
        catch (Exception e) {
            this.logger.error("getPersistentSize\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public Object get(String key) {
        try {
            if (this.supportExpiredCache) {
                return this.redisHelper.get(this.acquireListKey(key));
            }
            return this.redisHelper.hget(this.getCacheName(), key);
        }
        catch (Exception e) {
            this.logger.error("\u7f13\u5b58\u83b7\u5f97\u6570\u636e\u5f02\u5e38 get\uff1a" + key, (Throwable)e);
            return null;
        }
    }

    public Object get(String key, Class<?> clazz) {
        try {
            Object json = null;
            json = this.supportExpiredCache ? this.redisHelper.get(this.acquireListKey(key)) : this.redisHelper.hget(this.getCacheName(), key);
            if (json == null || StringUtils.isEmpty((String)json.toString())) {
                return null;
            }
            if (clazz == String.class) {
                return json.toString();
            }
            return JsonUtils.jsonStringToObject((String)json.toString(), clazz);
        }
        catch (Exception e) {
            this.logger.error("\u7f13\u5b58\u83b7\u5f97\u6570\u636e\u5f02\u5e38 get\uff1a" + key, (Throwable)e);
            return null;
        }
    }

    public void replace(String key, Object data) {
        this.put(key, data);
    }

    public void clear() {
        this.logger.warn("\u6e05\u9664redis\u7f13\u5b58\uff1a" + this.getCacheName());
        try {
            this.redisHelper.hdel(this.getCacheName());
        }
        catch (Exception e) {
            this.logger.error("\u6e05\u7a7a\u7f13\u5b58\u8868\u5f02\u5e38 clear\uff1a" + this.getCacheName(), (Throwable)e);
        }
    }

    public void updateCacheDataTimeStamp(String key) {
        throw new UnsupportedOperationException();
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String name) {
        this.cacheName = name;
    }

    public boolean isWriteOnDiskAfterShutdown() {
        return false;
    }

    public void setWriteOnDiskAfterShutdown(boolean boo) {
    }

    public long getExpiredTime() {
        return 0L;
    }

    public void setExpiredTime(int seconds) {
    }

    public Iterator<Cachable> getIterator() {
        throw new UnsupportedOperationException();
    }

    public Set<Object> getKeys() {
        if (this.supportExpiredCache) {
            throw new IllegalCallerException("\u8be5\u7f13\u5b58\u652f\u6301\u5931\u6548\u65f6\u95f4\uff0c\u65e0\u6cd5\u83b7\u53d6\u7f13\u5b58key\u96c6\u5408\u3002cacheName=" + this.getCacheName());
        }
        long size = this.redisHelper.hSize(this.getCacheName());
        if (size >= (long)CacheConfig.INIT_CACHEMAP_SIZE) {
            throw new RuntimeException("\u7f13\u5b58\u6570\u91cf\u8fc7\u5927\uff0c\u65e0\u6cd5\u8c03\u7528\u904d\u5386\u65b9\u6cd5\uff1a" + this.getCacheName());
        }
        Map<Object, Object> map = this.redisHelper.hmget(this.getCacheName());
        return map.keySet();
    }

    public List<String> getIterator(Class<?> clazz) {
        if (this.supportExpiredCache) {
            throw new IllegalCallerException("\u8be5\u7f13\u5b58\u652f\u6301\u5931\u6548\u65f6\u95f4\uff0c\u65e0\u6cd5\u83b7\u53d6\u7f13\u5b58\u96c6\u5408\u6570\u636e\u3002cacheName=" + this.getCacheName());
        }
        try {
            long size = this.redisHelper.hSize(this.getCacheName());
            if (size >= (long)CacheConfig.INIT_CACHEMAP_SIZE) {
                throw new RuntimeException("\u7f13\u5b58\u6570\u91cf\u8fc7\u5927\uff0c\u65e0\u6cd5\u8c03\u7528\u904d\u5386\u65b9\u6cd5\uff1a" + this.getCacheName());
            }
            Map<Object, Object> map = this.redisHelper.hmget(this.getCacheName());
            if (map != null) {
                ArrayList<String> result = new ArrayList<String>((int)size);
                for (Map.Entry<Object, Object> entry : map.entrySet()) {
                    result.add(entry.getValue().toString());
                }
                return result;
            }
        }
        catch (Exception e) {
            this.logger.error("getIterator\uff1a" + this.getCacheName(), (Throwable)e);
        }
        return null;
    }

    public void setCacheOperateListener(CacheOperateListener cacheOperateListener) {
    }

    @Deprecated
    public String getRootData(String key) {
        try {
            Object obj = this.redisHelper.get(key);
            if (obj != null) {
                return obj.toString();
            }
        }
        catch (Exception e) {
            this.logger.error("getRootData\uff1a" + key, (Throwable)e);
        }
        return null;
    }

    public long size() {
        try {
            if (this.supportExpiredCache) {
                this.logger.warn("\u652f\u6301\u5931\u6548\u65f6\u95f4\u7684\u7f13\u5b58\u6570\u636e\uff0c\u65e0\u6cd5\u83b7\u53d6\u5143\u7d20\u4e2a\u6570\uff0ccacheName=" + this.getCacheName());
                return 0L;
            }
            return this.redisHelper.hSize(this.getCacheName());
        }
        catch (Exception e) {
            this.logger.error("size\uff1a" + e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public Collection<Object> queryListLimit(int maxSize) {
        if (this.supportExpiredCache) {
            throw new IllegalCallerException("\u8be5\u7f13\u5b58\u652f\u6301\u5931\u6548\u65f6\u95f4\uff0c\u65e0\u6cd5\u83b7\u53d6\u7f13\u5b58\u96c6\u5408\u6570\u636e\u3002");
        }
        if (maxSize < 0 || maxSize >= Integer.MAX_VALUE) {
            return null;
        }
        try {
            long cacheSize = this.redisHelper.hSize(this.getCacheName());
            if (cacheSize <= (long)maxSize) {
                Map<Object, Object> datas = this.redisHelper.hmget(this.getCacheName());
                if (datas == null) {
                    return null;
                }
                ArrayList<Object> resultList = new ArrayList<Object>();
                for (Object obj : datas.values()) {
                    resultList.add(obj.toString());
                }
                return resultList;
            }
            throw new IllegalArgumentException("\u7f13\u5b58\u6570\u91cf\u5927\u4e8e\u7ed9\u5b9a\u7684\u9650\u5236\u503c\uff0c\u4e0d\u80fd\u663e\u793a\u6570\u636e\uff0c\u6570\u91cf\u8fc7\u5927");
        }
        catch (Exception e) {
            this.logger.error("queryListLimit\uff1a" + e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

