/*
 * Decompiled with CFR 0.152.
 */
package com.walker.support.redis.cache;

import com.walker.db.page.GenericPager;
import com.walker.db.page.ListPageContext;
import com.walker.support.redis.cache.RedisCache;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RedisPageCache
extends RedisCache {
    private static final long serialVersionUID = 1918144861581384722L;
    private String nameKeySet = this.getCacheName() + "set";

    public RedisPageCache(String providerName, Map<String, String> param) {
        super(providerName, param);
    }

    public void putSort(double score, String id, String data) {
        try {
            this.getRedisHelper().sortSetAdd(this.nameKeySet, id, score);
            this.getRedisHelper().hset(this.getCacheName(), id, data);
        }
        catch (Exception e) {
            this.logger.error("putSort \u5f02\u5e38\uff1a" + id, (Throwable)e);
        }
    }

    public void removeSort(String id) {
        try {
            this.getRedisHelper().sortSetRemove(this.nameKeySet, id);
            this.getRedisHelper().hdel(this.getCacheName(), id);
        }
        catch (Exception e) {
            this.logger.error("removeSort \u5f02\u5e38\uff1a" + id, (Throwable)e);
        }
    }

    public GenericPager<Object> queryListPage(int pageIndex, int pageSize) {
        try {
            Long sizeObj = this.getRedisHelper().hSize(this.getCacheName());
            GenericPager pager = ListPageContext.createGenericPager((List)null, (int)pageIndex, (int)pageSize, (int)(sizeObj == null ? 0 : sizeObj.intValue()));
            int startIndex = (int)pager.getFirstRowIndexInPage();
            Set<Object> dataSet = this.getRedisHelper().sortSetRange(this.nameKeySet, startIndex, startIndex + pageSize - 1);
            if (dataSet != null && dataSet.size() > 0) {
                this.logger.debug(dataSet.toString());
                String[] arrayString = new String[dataSet.size()];
                pager.setDatas(this.getRedisHelper().hmGetList(this.getCacheName(), dataSet));
            }
            return pager;
        }
        catch (Exception e) {
            this.logger.error("queryListPage \u5f02\u5e38\uff1a" + this.getCacheName(), (Throwable)e);
            return null;
        }
    }

    @Override
    public Collection<Object> queryListLimit(int maxSize) {
        if (maxSize < 0 || maxSize >= Integer.MAX_VALUE) {
            return null;
        }
        try {
            long cacheSize = 0L;
            Long result = this.getRedisHelper().hSize(this.getCacheName());
            if (result != null) {
                cacheSize = result;
            }
            long mySize = 0L;
            mySize = cacheSize <= (long)maxSize ? cacheSize : (long)maxSize;
            if (mySize <= 0L) {
                return null;
            }
            Set<Object> dataSet = this.getRedisHelper().sortSetRange(this.nameKeySet, 0L, mySize - 1L);
            if (dataSet != null) {
                String[] arrayString = new String[dataSet.size()];
                return this.getRedisHelper().hmGetList(this.getCacheName(), dataSet);
            }
            return null;
        }
        catch (Exception e) {
            this.logger.error("queryListLimit \u5f02\u5e38\uff1a" + this.getCacheName(), (Throwable)e);
            return null;
        }
    }

    @Override
    public void replace(String key, Object data) {
        try {
            this.getRedisHelper().hset(this.getCacheName(), key, data);
        }
        catch (Exception e) {
            this.logger.error("replace \u5f02\u5e38\uff1a" + key + ", " + data, (Throwable)e);
        }
    }

    @Override
    public void put(String key, Object data) {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u65b9\u6cd5\uff1a\u5206\u9875\u7f13\u5b58\u4e2d\uff0c\u4e0d\u80fd\u76f4\u63a5\u8c03\u7528put\u65b9\u6cd5");
    }
}

