/*
 * Decompiled with CFR 0.152.
 */
package com.walker.support.redis.cache;

import com.walker.cache.Cache;
import com.walker.cache.PageCacheProvider;
import com.walker.db.page.GenericPager;
import com.walker.support.redis.RedisHelper;
import com.walker.support.redis.cache.RedisCacheProvider;
import com.walker.support.redis.cache.RedisPageCache;
import java.util.Map;

public abstract class RedisPageCacheProvider
extends RedisCacheProvider<String>
implements PageCacheProvider {
    private RedisHelper redisHelper;

    @Override
    public void setRedisHelper(RedisHelper redisHelper) {
        this.redisHelper = redisHelper;
    }

    @Override
    protected Cache provideCacheInstance(String name, Map<String, String> param) {
        if (this.isUseRedis()) {
            RedisPageCache cache = new RedisPageCache(name, param);
            cache.setRedisHelper(this.redisHelper);
            return cache;
        }
        return super.provideCacheInstance(name, param);
    }

    @Override
    protected RedisPageCache getRedisCache() {
        return (RedisPageCache)this.getCache();
    }

    public GenericPager<Object> queryListPage(int pageIndex, int pageSize) {
        if (!this.isUseRedis()) {
            throw new IllegalArgumentException("'queryListPage'\u65b9\u6cd5\u5fc5\u987b\u4f7f\u7528redis\u7f13\u5b58\u5b9e\u73b0");
        }
        return this.getRedisCache().queryListPage(pageIndex, pageSize);
    }

    @Override
    public String getCacheData(String key) {
        if (this.isUseRedis()) {
            Object data = this.getRedisCache().get(key);
            return data == null ? "" : data.toString();
        }
        return (String)super.getCacheData(key);
    }

    @Override
    @Deprecated
    public long getCacheCount() {
        return this.getRedisCache().size();
    }

    public long size() {
        return this.getRedisCache().size();
    }

    @Override
    public void removeCacheData(String key) {
        if (this.isUseRedis()) {
            this.getRedisCache().removeSort(key);
        } else {
            super.removeCacheData(key);
        }
    }

    @Override
    public void updateCacheData(String key, String data) {
        if (this.isUseRedis()) {
            this.getRedisCache().replace(key, data);
        } else {
            super.updateCacheData(key, data);
        }
    }

    @Override
    public void putCacheData(String key, String data) {
        throw new UnsupportedOperationException("\u5206\u9875Redis\u7f13\u5b58\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5\uff0c\u8bf7\u4f7f\u7528'putCacheSort'");
    }

    public void putCacheSort(String key, double sort, String data) {
        if (!this.isUseRedis()) {
            throw new IllegalArgumentException("'putCacheSort'\u65b9\u6cd5\u5fc5\u987b\u4f7f\u7528redis\u7f13\u5b58\u5b9e\u73b0");
        }
        this.getRedisCache().putSort(sort, key, data);
    }
}

