package com.walker.remote;

import com.walker.infrastructure.utils.StringUtils;

import java.io.UnsupportedEncodingException;

/**
 * 抽象加密解密编码器-默认实现
 * @author shikeying
 * @date 2015-2-5
 *
 */
public abstract class AbstractByteCoder {
	
//	protected final static String CHARSET_UTF8 = "utf-8";
	
	public byte[] encrypt(String paramString){
	    try{
	      return encrypt(paramString.getBytes(StringUtils.DEFAULT_CHARSET_UTF8));
	    } catch (UnsupportedEncodingException e){
	    	throw new RuntimeException();
	    }
	}

	public String encryptToString(byte[] paramArrayOfByte){
	    byte[] arrayOfByte = encrypt(paramArrayOfByte);
	    if (arrayOfByte == null)
	      return null;
	    try{
	      return new String(arrayOfByte, StringUtils.DEFAULT_CHARSET_UTF8);
	    }catch (UnsupportedEncodingException e){
	    	throw new RuntimeException();
	    }
	}

	/**
	 * 把给定的字节数组加密
	 * @param sourceBytes 原始字节数组
	 * @return
	 */
	public abstract byte[] encrypt(byte[] sourceBytes);

//	public final String b(String paramString){
//	    try{
//	      byte[] arrayOfByte = encrypt(paramString);
//	      if (arrayOfByte == null)
//	        return null;
//	      return new String(arrayOfByte, CHARSET_UTF8);
//	    }
//	    catch (UnsupportedEncodingException e){
//	    	throw new RuntimeException();
//	    }
//	}

	/**
	 * 把已经加密（通过encrypt方法）的字节数组解密
	 * @param encodeBytes 加密过的字节数据组
	 * @return
	 */
	public abstract byte[] decrypt(byte[] encodeBytes);

	/**
	 * 解密给定字符串
	 * @param paramString 给定加过密的字符串
	 * @return
	 */
	public byte[] decrypt(String paramString){
	    if (paramString == null)
	      return null;
	    try{
	      return decrypt(paramString.getBytes(StringUtils.DEFAULT_CHARSET_UTF8));
	    }
	    catch (UnsupportedEncodingException e){
	    	throw new RuntimeException();
	    }
	}
}
