package com.walker.remote;

import com.walker.api.client.ResponseData;
import org.apache.hc.client5.http.cookie.CookieStore;

import java.util.Map;

/**
 * 远程访问接口定义，系统最基本的核心接口之一。</p>
 * 通过该接口可以远程调用各种服务，如：socket、http、webservice等
 * @author shikeying
 * @date 2015-2-7
 *
 */
public interface RemoteAccessor{

	/**
	 * 同步远程服务调用。
	 * @param methodName
	 * @param simpleData
	 * @param jsonParameter
	 * @param responseData 给定一个响应对象的实例，如：new ResponseLogin()
	 * @return
	 */
	public abstract <T> T requestTextSync(String methodName, Map<String, String> simpleData,
			String jsonParameter, ResponseData<T> responseData);
	
	
	/**
	 * 设置调用接口对传输内容的加密方式，可能有多种实现，需要调用方配置一个。<br>
	 * 如果不设置，系统默认使用<code>Base64</code>进行简单编码。
	 * @param byteCoder
	 */
	void setContentEncoder(AbstractByteCoder byteCoder);
	
	/**
	 * 设置访问服务端的基础路径，如：http://www.abc.com:8080/app/request.do
	 * @param baseUrl
	 */
	void setBaseUrl(String baseUrl);
	
	/**
	 * 设置客户端证书信息，双向认证使用
	 * @param doubleTrust
	 */
	void setDoubleTrust(DoubleTrust doubleTrust);
	
//	public abstract void setTimeRecorder(TimeRecorder timeRecorder);

	<T> T requestTextSyncWithCookie(String methodName, Map<String, String> simpleData, String jsonParameter, ResponseData<T> responseData, CookieStore cookieStore);

	<T> T requestSyncDelete(String methodName, String jsonParameter, Map<String, String> header, ResponseData<T> responseData);


	<T> T requestSyncPut(String methodName, String jsonParameter, Map<String, String> header, ResponseData<T> responseData);


	<T> T requestSyncPost(String methodName, String jsonParameter, Map<String, String> header, ResponseData<T> responseData);


	<T> T requestSyncWithoutGet(String methodName, String jsonParameter, String methodType, Map<String, String> header, ResponseData<T> responseData);


	<T> T requestSync(String methodName, Map<String, String> simpleData, String jsonParameter, String methodType, String contentType, Map<String, String> header, ResponseData<T> responseData);

	/**
	 * 默认的提交json格式数据的参数名字，不能直接提交json，必须添加表单名称，<br>
	 * 否则服务端无法接收参数。
	 */
	public static final String DEFALUT_FORM_DATA_NAME = "datas";
	
	/**
	 * 响应返回的结果中以特殊标志开头的内容：此时表示http请求返回的不是html内容，而是重新跳转等额外信息
	 */
	public static final String RESPONSE_EXT_ID = "ext//";
	
}
