package com.walker.remote.support;

import com.walker.api.client.ResponseData;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.remote.AbstractByteCoder;
import com.walker.remote.Constants;
import com.walker.remote.DoubleTrust;
import com.walker.remote.RemoteAccessor;
import org.apache.hc.client5.http.cookie.CookieStore;

import java.util.Map;

/**
 * 一个<code>RemoteAccessor</code>对象负责一个链接到某个ip的状态；<br>
 * 如果连接不同的服务端，需要使用多个此对象。
 * @author shikeying
 * @date 2015年12月11日
 *
 */
public class DefaultRemoteAccessor implements RemoteAccessor {

	private AbstractByteCoder contentCoder = null;
	
	private String baseUrl; // 应用程序存储本地文件的根路径
	
	private DoubleTrust doubleTrust;
	
	@Override
	public <T> T requestSync(String methodName, Map<String, String> simpleData
			, String jsonParameter, String methodType, String contentType, Map<String, String> header
			, ResponseData<T> responseData){
		checkRequired();
		HttpRemoteTask<T> remoteTask = new HttpRemoteTask<T>();
		remoteTask.setDoubleTrust(doubleTrust);
		remoteTask.setContentCoder(contentCoder);
		remoteTask.setResponseData(responseData);
		// 设置简单参数，并优先处理
		if(simpleData != null && simpleData.size() > 0){
			remoteTask.setSimpleData(simpleData);
		}
//		((HttpRemoteTask<T>)remoteTask).setTimeRecorder(timeRecorder);
		return remoteTask.execute(baseUrl+methodName, simpleData, jsonParameter, methodType, contentType, header);
	}
	
	@Override
	public <T> T requestSyncWithoutGet(String methodName
			, String jsonParameter, String methodType, Map<String, String> header
			, ResponseData<T> responseData){
		return this.requestSync(methodName, null, jsonParameter, methodType, Constants.APPLICATION_JSON, header, responseData);
	}
	
	@Override
	public <T> T requestSyncPost(String methodName
			, String jsonParameter, Map<String, String> header
			, ResponseData<T> responseData){
		return this.requestSyncWithoutGet(methodName, jsonParameter, Constants.HTTP_METHOD_POST, header, responseData);
	}
	@Override
	public <T> T requestSyncPut(String methodName
			, String jsonParameter, Map<String, String> header
			, ResponseData<T> responseData){
		return this.requestSyncWithoutGet(methodName, jsonParameter, Constants.HTTP_METHOD_PUT, header, responseData);
	}
	@Override
	public <T> T requestSyncDelete(String methodName
			, String jsonParameter, Map<String, String> header
			, ResponseData<T> responseData){
		return this.requestSyncWithoutGet(methodName, jsonParameter, Constants.HTTP_METHOD_DELETE, header, responseData);
	}
	
	/**
	 * 同步远程服务调用。
	 * @param methodName
	 * @param simpleData
	 * @param jsonParameter
	 * @param responseData 给定一个响应对象的实例，如：new ResponseLogin()
	 * @return
	 */
	@Override
	public <T> T requestTextSync(String methodName, Map<String, String> simpleData
			, String jsonParameter, ResponseData<T> responseData){
		checkRequired();
		HttpRemoteTask<T> remoteTask = new HttpRemoteTask<T>();
		remoteTask.setDoubleTrust(doubleTrust);
		remoteTask.setContentCoder(contentCoder);
		remoteTask.setResponseData(responseData);
		// 设置简单参数，并优先处理
		if(simpleData != null && simpleData.size() > 0){
			remoteTask.setSimpleData(simpleData);
		}
//		((HttpRemoteTask<T>)remoteTask).setTimeRecorder(timeRecorder);
		return remoteTask.execute(baseUrl+methodName, jsonParameter);
	}
	
	/**
	 * 带cookie的请求，请求后可以从输入的cookie中获取数据
	 * @param methodName
	 * @param simpleData
	 * @param jsonParameter
	 * @param responseData
	 * @param cookieStore
	 * @return
	 */
	@Override
	public <T> T requestTextSyncWithCookie(String methodName, Map<String, String> simpleData
			, String jsonParameter, ResponseData<T> responseData
			, CookieStore cookieStore){
		checkRequired();
		HttpRemoteTask<T> remoteTask = new HttpRemoteTask<T>();
		remoteTask.setDoubleTrust(doubleTrust);
		remoteTask.setContentCoder(contentCoder);
		remoteTask.setResponseData(responseData);
		// 设置简单参数，并优先处理
		if(simpleData != null && simpleData.size() > 0){
			remoteTask.setSimpleData(simpleData);
		}
//		return remoteTask.execute(baseUrl+methodName, jsonParameter);
		return remoteTask.execute(baseUrl+methodName, jsonParameter, cookieStore);
	}
	
	private void checkRequired(){
//		if(contentCoder == null || context == null || StringUtils.isEmpty(baseUrl)){
//			throw new IllegalArgumentException();
//		}
		
		//contentCoder 可以为空，为空时不进行加解密，李润冬2015-07-28
		if(StringUtils.isEmpty(baseUrl)){
			throw new IllegalArgumentException();
		}
	}

	@Override
	public void setContentEncoder(AbstractByteCoder byteCoder) {
		this.contentCoder = byteCoder;
	}

	@Override
	public void setBaseUrl(String baseUrl) {
		this.baseUrl = baseUrl;
	}

	@Override
	public void setDoubleTrust(DoubleTrust doubleTrust) {
		this.doubleTrust = doubleTrust;
	}

}
