package com.walker.remote.util;

import com.walker.remote.AbstractByteCoder;
import com.walker.remote.DoubleTrust;
import com.walker.remote.RemoteAccessor;
import com.walker.remote.RemoteAccessorException;
import com.walker.remote.support.DefaultRemoteAccessor;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.util.Timeout;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

import javax.net.ssl.SSLContext;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HttpUtils {
	
//	private Log logger = LogFactory.getLog(getClass());

	// http调用客户端
	private HttpClient httpClient = null;
//	private AbstractByteCoder contentCoder = null;
	
	private static HttpUtils httpUtils;
	
	private HttpUtils(){
//		beanFactory = new DefaultBeanFactory();
//		BeanFactoryHelper.setBeanFactory(beanFactory);
//		
//		httpClient = doCreateSafeHttpClient();
//		beanFactory.addBean(HttpClient.class, httpClient);
//		this.doCreateRemoteAccessor();
		httpClient = this.doCreateSafeHttpClient(null, null);
	}
	
	public static HttpUtils getInstance(){
		if(httpUtils == null){
			httpUtils = new HttpUtils();
		}
		return httpUtils;
	}
	
	public HttpClient getHttpClient() {
		return httpClient;
//		return doGetNewHttpClient();
	}
	
	/**
	 * 返回设置过cookie的httpClient对象，每次都要新创建
	 * 
	 * @param cookieStore
	 * @return
	 */
	public HttpClient getHttpClientWithCookie(CookieStore cookieStore) {
//		return httpClient;
		return this.doCreateSafeHttpClient(null, cookieStore);
	}
	
	/**
	 * 返回一个双向认证的<code>HttpClient</code>对象。</p>
	 * 注意：在上层应用中，该方法通常被初始化调用，而不是每次使用都被频繁获取。
	 * @param doubleTrust
	 * @return
	 */
	public HttpClient getHttpDoubleTrustClient(DoubleTrust doubleTrust, CookieStore cookieStore) {
		return  this.doCreateSafeHttpClient(doubleTrust, cookieStore);
//		try{
//			// 重新加入https信息
//			KeyStore trustStore  = KeyStore.getInstance(KeyStore.getDefaultType());
//			FileInputStream instream = new FileInputStream(new File(doubleTrust.getCerFilepath()));
//			//密匙库的密码
//			trustStore.load(instream, doubleTrust.getPassword().toCharArray());
//			//注册密匙库          
//			SSLSocketFactory socketFactory = new SSLSocketFactory(trustStore);
//			//不校验域名
//			socketFactory.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
//			Scheme sch = new Scheme("https", 443, socketFactory);      
//			httpClient.getConnectionManager().getSchemeRegistry().register(sch);
//			return httpClient;
//		} catch(Exception ex){
//			ex.printStackTrace();
//			return null;
//		}
	}
	
	/**
	 * 创建线程安全的<code>HttpClient</code>对象。
	 * @return
	 */
	private HttpClient doCreateSafeHttpClient(DoubleTrust clientTrust, CookieStore cookieStore){
//		HttpParams params = new BasicHttpParams();
//		
//        //设置基本参数  
//        HttpProtocolParams.setVersion(params, HttpVersion.HTTP_1_1);
//        HttpProtocolParams.setContentCharset(params, StringUtils.DEFAULT_CHARSET_UTF8);  
//        HttpProtocolParams.setUserAgent(params, "HttpComponents/1.1");
//        
//        HttpConnectionParams.setStaleCheckingEnabled(params, false);
//        HttpConnectionParams.setTcpNoDelay(params, true);
//        HttpConnectionParams.setSocketBufferSize(params, 8 * 1024);
//        
//        HttpClientParams.setRedirecting(params, false);
//        
//        //超时设置  
//		params.setParameter(CoreConnectionPNames.CONNECTION_TIMEOUT, 15000);
//	    params.setParameter(CoreConnectionPNames.SO_TIMEOUT, 15000);
//	    // 该值就是连接不够用的时候等待超时时间，一定要设置，而且不能太大 ()
//	    params.setLongParameter(ClientPNames.CONN_MANAGER_TIMEOUT, 500L);
//	    // 在提交请求之前 测试连接是否可用
//	    params.setBooleanParameter(CoreConnectionPNames.STALE_CONNECTION_CHECK, true);
//	    
//        //设置HttpClient支持HTTp和HTTPS两种模式  
//        SchemeRegistry schReg = new SchemeRegistry();  
////        schReg.register(new Scheme("http", PlainSocketFactory.getSocketFactory(), 80));  
////        schReg.register(new Scheme("https", SSLSocketFactory.getSocketFactory(), 443));
//        schReg.register(new Scheme("http", 80, PlainSocketFactory.getSocketFactory()));
//        try {
//			schReg.register(new Scheme("https", 443, getSSLSocketFactory(clientTrust)));
//		} catch (KeyManagementException e) {
//			e.printStackTrace();
//			throw new IllegalStateException("KeyManagementException: 创建ssl httpclient证书错误：" + e.getMessage());
//		} catch (NoSuchAlgorithmException e) {
//			e.printStackTrace();
//			throw new IllegalStateException("NoSuchAlgorithmException: 创建ssl httpclient算法错误：" + e.getMessage());
//		} catch(FileNotFoundException ex){
//			throw new IllegalStateException("FileNotFoundException: 创建ssl失败未找到客户端证书：" + ex.getMessage());
//		} catch(Exception rex){
//			throw new IllegalStateException(rex);
//		}
//        
//        PoolingClientConnectionManager conMgr = new PoolingClientConnectionManager(schReg); 
//        conMgr.setDefaultMaxPerRoute(128); //每个主机的最大并行链接数   
//        conMgr.setMaxTotal(512);          //客户端总并行链接最大数
//        
//        HttpClient client = new DefaultHttpClient(conMgr, params); 
//        return client;
		CloseableHttpClient httpclient = null;

		//密匙库的密码
		InputStream instream = null;
		Resource resource = null;
		KeyStore keyStore = null;
		PoolingHttpClientConnectionManager cm = null;
		try {
			resource = new ClassPathResource(clientTrust.getCerFilepath());
			instream = resource.getInputStream();
			keyStore = KeyStore.getInstance("PKCS12");
//				instream = new FileInputStream(new File(clientTrust.getCerFilepath()));
//				keyStore.load(instream, clientTrust.getPassword().toCharArray());
			keyStore.load(instream, clientTrust.getPassword().toCharArray());
		} catch (Exception ex){
			throw new RemoteAccessorException("加载证书错误: " + clientTrust.getCerFilepath(), ex);
		}

		try {
			SSLContext sslcontext = SSLContexts.custom()
					.loadKeyMaterial(keyStore, clientTrust.getPassword().toCharArray()).build();

			// Allow TLSv1 protocol only
			SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(
					sslcontext,
					new String[] {"TLSv1", "TLSv1.1", "TLSv1.2"},
					null,
//		                SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER
//		                SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER
					new NoopHostnameVerifier()
			);
			//
			SocketConfig socketConfig = SocketConfig.custom()
					.setSoTimeout(Timeout.ofSeconds(10))
					.build();

			cm = PoolingHttpClientConnectionManagerBuilder.create()
					.setDefaultSocketConfig(socketConfig)
					.setSSLSocketFactory(sslsf).build();
			cm.setDefaultMaxPerRoute(128);
			cm.setMaxTotal(512);
		} catch (Exception ex){
			throw new RemoteAccessorException("SSLContext 异常: " + ex.getMessage(), ex);
		}

		if(clientTrust != null){
			try {
		        httpclient = HttpClients.custom().setConnectionManager(cm).build();
		        
			} catch (Exception e) {
				e.printStackTrace();
				throw new RuntimeException(e);
			} finally {
				try {
					instream.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
	        }
		} else {
			if(cookieStore != null){
				httpclient = HttpClients.custom().setConnectionManager(cm).setDefaultCookieStore(cookieStore).build();
			} else {
				httpclient = HttpClients.custom().setConnectionManager(cm).build();
			}
		}
		return httpclient;
	}
	
//	private static SSLSocketFactory getSSLSocketFactory(DoubleTrust clientTrust) 
//			throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, FileNotFoundException{
//		SSLContext ctx = SSLContext.getInstance("TLSv1");
//		TrustManager[] trustManagers = null;
//		
//		if(clientTrust != null){
//			// 如果存在双向认证
//			// 重新加入https信息
//			KeyStore trustStore  = KeyStore.getInstance("PKCS12");
//			FileInputStream instream = new FileInputStream(new File(clientTrust.getCerFilepath()));
//			//密匙库的密码
//			try {
//				trustStore.load(instream, clientTrust.getPassword().toCharArray());
//			} catch (Exception e) {
//				e.printStackTrace();
//				throw new RuntimeException(e);
//			}
//			TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");  
//	        tmf.init(trustStore);
//	        trustManagers = tmf.getTrustManagers();
//	        
//		} else {
//			X509TrustManager tm = new X509TrustManager() {
//				@Override
//				public void checkClientTrusted(java.security.cert.X509Certificate[] chain, String authType)
//						throws java.security.cert.CertificateException {
//					
//				}
//				
//				@Override
//				public void checkServerTrusted(java.security.cert.X509Certificate[] chain, String authType)
//						throws java.security.cert.CertificateException {
//					
//				}
//				
//				@Override
//				public java.security.cert.X509Certificate[] getAcceptedIssuers() {
//					return null;
//				}
//			};
//			trustManagers = new TrustManager[]{tm};
//		}
//		
//        ctx.init(null, trustManagers, null);
//        return new SSLSocketFactory(ctx, SSLSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
//	}
	
//	private HttpClient doGetNewHttpClient(){
//		HttpParams params = new BasicHttpParams();
//		
//        //设置基本参数  
//        HttpProtocolParams.setVersion(params, HttpVersion.HTTP_1_1);  
//        HttpProtocolParams.setContentCharset(params, StringUtils.DEFAULT_CHARSET_UTF8);  
//        HttpProtocolParams.setUserAgent(params, "Android client");
//        
//        HttpConnectionParams.setStaleCheckingEnabled(params, false);
//        HttpConnectionParams.setTcpNoDelay(params, true);
//        HttpConnectionParams.setSocketBufferSize(params, 8 * 1024);
//        
//        HttpClientParams.setRedirecting(params, false);
//        /*连接超时*/  
//        HttpConnectionParams.setConnectionTimeout(params, 20000);  
//        /*请求超时*/  
//        HttpConnectionParams.setSoTimeout(params, 20000); 
//        HttpClient client = new DefaultHttpClient(params);  
//        return client;
//	}
	
	public static List<NameValuePair> doTranslatePairs(Map<String, String> simpleData){
		List<NameValuePair> pair = new ArrayList<NameValuePair>();
		for(Map.Entry<String, String> entry : simpleData.entrySet()){
			pair.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
		}
		return pair;
	}
	
	/**
	 * 把json格式参数转换为特定http参数
	 * @param json
	 * @return
	 */
	public static List<NameValuePair> doTranslatePairs(String json){
		List<NameValuePair> pair = new ArrayList<NameValuePair>();
		pair.add(new BasicNameValuePair(RemoteAccessor.DEFALUT_FORM_DATA_NAME, json));
		return pair;
	}
	
	/**
	 * 返回一个通用的远程访问对象
	 * @param contentCoder
	 * @return
	 */
	public RemoteAccessor getNewRemoteAccessor(String remoteURL
			, AbstractByteCoder contentCoder, DoubleTrust doubleTrust){
//		String remoteURL = getRemoteServerURL();
		RemoteAccessor remoteAccessor = new DefaultRemoteAccessor();
		remoteAccessor.setBaseUrl(remoteURL);
		remoteAccessor.setContentEncoder(contentCoder);
		// 设置双向认证的客户端证书，如果存在
		remoteAccessor.setDoubleTrust(doubleTrust);
		return remoteAccessor;
	}
	
//	/**
//	 * 添加远程请求单例对象。<br>
//	 * 此方法放在<code>initialize()</code>方法之后，是因为需要子类先提供服务端访问URL地址，才能初始化该对象。
//	 */
//	private void doCreateRemoteAccessor(){
//		String remoteURL = getRemoteServerURL();
//		logger.debug("............应用启动，获得一次RemoteURL: " + remoteURL);
//		contentCoder = new Base64ByteCoder();
//		RemoteAccessor remoteAccessor = new DefaultRemoteAccessor();
//		remoteAccessor.setBaseUrl(remoteURL);
//		remoteAccessor.setContentEncoder(contentCoder);
//	}
	
//	private String getRemoteServerURL(){
//		return "http://opentest.17wanxiao.com:80/campus/";
//		return "http://120.55.104.155:80/campus/";
//		return "http://www.17wanxiao.com/campus/";
//	}
}
