/*
 * Decompiled with CFR 0.152.
 */
package com.walker.remote;

import com.walker.api.client.ResponseData;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.remote.AbstractByteCoder;
import com.walker.remote.RemoteAccessorException;
import com.walker.remote.ResultData;
import java.util.Map;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RemoteSyncTask<T> {
    private AbstractByteCoder contentCoder;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, String> simpleData;
    private boolean serverFailed = false;
    private ResponseData<T> responseData;

    public boolean isServerFailed() {
        return this.serverFailed;
    }

    public Map<String, String> getSimpleData() {
        return this.simpleData;
    }

    protected AbstractByteCoder getContentCoder() {
        return this.contentCoder;
    }

    public void setSimpleData(Map<String, String> simpleData) {
        this.simpleData = simpleData;
    }

    public void setContext() {
    }

    public RemoteSyncTask<T> setContentCoder(AbstractByteCoder contentCoder) {
        this.contentCoder = contentCoder;
        return this;
    }

    public T execute(String url, String jsonData) {
        if (StringUtils.isEmpty((String)url)) {
            throw new RemoteAccessorException("\u7f3a\u5c11\u8bf7\u6c42http\u8c03\u7528\u53c2\u6570");
        }
        String result = null;
        try {
            result = this.requestForData(this.simpleData, url, jsonData);
        }
        catch (RemoteAccessorException e) {
            e.printStackTrace();
            if (e.isServerFailed()) {
                this.serverFailed = true;
                this.logger.debug("\u670d\u52a1\u7aef\u8fde\u63a5\u5f02\u5e38");
            }
            this.logger.debug(e.getMessage(), (Throwable)((Object)e));
        }
        if (result != null) {
            return this.processDataUI(result);
        }
        this.responseEmpty();
        return null;
    }

    public T execute(String url, String jsonData, CookieStore cookieStore) {
        if (StringUtils.isEmpty((String)url)) {
            throw new RemoteAccessorException("\u7f3a\u5c11\u8bf7\u6c42http\u8c03\u7528\u53c2\u6570");
        }
        ResultData result = null;
        try {
            result = this.requestForDataAndCookie(this.simpleData, url, jsonData, cookieStore);
        }
        catch (RemoteAccessorException e) {
            e.printStackTrace();
            if (e.isServerFailed()) {
                this.serverFailed = true;
                this.logger.debug("\u670d\u52a1\u7aef\u8fde\u63a5\u5f02\u5e38");
            }
            this.logger.debug(e.getMessage(), (Throwable)((Object)e));
        }
        if (result != null) {
            return this.processDataUI(result.getHtml());
        }
        this.responseEmpty();
        return null;
    }

    public T execute(String url, Map<String, String> simpleData, String jsonData, String methodType, String contentType, Map<String, String> header) {
        if (StringUtils.isEmpty((String)url)) {
            throw new RemoteAccessorException("\u7f3a\u5c11\u8bf7\u6c42http\u8c03\u7528\u53c2\u6570");
        }
        String result = null;
        try {
            result = this.requestForData(simpleData, url, jsonData, methodType, contentType, header);
        }
        catch (RemoteAccessorException e) {
            e.printStackTrace();
            if (e.isServerFailed()) {
                this.serverFailed = true;
                this.logger.debug("\u670d\u52a1\u7aef\u8fde\u63a5\u5f02\u5e38");
            }
            this.logger.debug(e.getMessage(), (Throwable)((Object)e));
        }
        if (result != null) {
            return this.processDataUI(result);
        }
        this.responseEmpty();
        return null;
    }

    protected T processDataUI(String data) {
        String result = data.toString();
        if (!StringUtils.isEmpty((String)result)) {
            this.logger.debug("============= \u6267\u884c\u4e86\u65b9\u6cd5\uff1acreateResponseData(),result = " + result);
            if (this.responseData == null) {
                throw new IllegalStateException("please implementation createResponseData()!");
            }
            this.responseData.toObjectFromJson(result);
            if (!this.responseData.getStatus()) {
                this.logger.debug(this.responseData.getMessage());
            }
            return (T)this.responseData.getResultData();
        }
        return null;
    }

    protected abstract String requestForData(Map<String, String> var1, String var2, String var3) throws RemoteAccessorException;

    protected abstract String requestForData(Map<String, String> var1, String var2, String var3, String var4, String var5, Map<String, String> var6) throws RemoteAccessorException;

    protected abstract ResultData requestForDataAndCookie(Map<String, String> var1, String var2, String var3, CookieStore var4) throws RemoteAccessorException;

    protected abstract void responseEmpty();

    public void setResponseData(ResponseData<T> responseData) {
        this.responseData = responseData;
    }
}

