/*
 * Decompiled with CFR 0.152.
 */
package com.walker.remote.support;

import com.walker.api.client.ResponseData;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.remote.AbstractByteCoder;
import com.walker.remote.DoubleTrust;
import com.walker.remote.RemoteAccessor;
import com.walker.remote.support.HttpRemoteTask;
import java.util.Map;
import org.apache.hc.client5.http.cookie.CookieStore;

public class DefaultRemoteAccessor
implements RemoteAccessor {
    private AbstractByteCoder contentCoder = null;
    private String baseUrl;
    private DoubleTrust doubleTrust;

    @Override
    public <T> T requestSync(String methodName, Map<String, String> simpleData, String jsonParameter, String methodType, String contentType, Map<String, String> header, ResponseData<T> responseData) {
        this.checkRequired();
        HttpRemoteTask<T> remoteTask = new HttpRemoteTask<T>();
        remoteTask.setDoubleTrust(this.doubleTrust);
        remoteTask.setContentCoder(this.contentCoder);
        remoteTask.setResponseData(responseData);
        if (simpleData != null && simpleData.size() > 0) {
            remoteTask.setSimpleData(simpleData);
        }
        return remoteTask.execute(this.baseUrl + methodName, simpleData, jsonParameter, methodType, contentType, header);
    }

    @Override
    public <T> T requestSyncWithoutGet(String methodName, String jsonParameter, String methodType, Map<String, String> header, ResponseData<T> responseData) {
        return this.requestSync(methodName, null, jsonParameter, methodType, "application/json;charset=UTF-8", header, responseData);
    }

    @Override
    public <T> T requestSyncPost(String methodName, String jsonParameter, Map<String, String> header, ResponseData<T> responseData) {
        return this.requestSyncWithoutGet(methodName, jsonParameter, "POST", header, responseData);
    }

    @Override
    public <T> T requestSyncPut(String methodName, String jsonParameter, Map<String, String> header, ResponseData<T> responseData) {
        return this.requestSyncWithoutGet(methodName, jsonParameter, "PUT", header, responseData);
    }

    @Override
    public <T> T requestSyncDelete(String methodName, String jsonParameter, Map<String, String> header, ResponseData<T> responseData) {
        return this.requestSyncWithoutGet(methodName, jsonParameter, "DELETE", header, responseData);
    }

    @Override
    public <T> T requestTextSync(String methodName, Map<String, String> simpleData, String jsonParameter, ResponseData<T> responseData) {
        this.checkRequired();
        HttpRemoteTask<T> remoteTask = new HttpRemoteTask<T>();
        remoteTask.setDoubleTrust(this.doubleTrust);
        remoteTask.setContentCoder(this.contentCoder);
        remoteTask.setResponseData(responseData);
        if (simpleData != null && simpleData.size() > 0) {
            remoteTask.setSimpleData(simpleData);
        }
        return remoteTask.execute(this.baseUrl + methodName, jsonParameter);
    }

    @Override
    public <T> T requestTextSyncWithCookie(String methodName, Map<String, String> simpleData, String jsonParameter, ResponseData<T> responseData, CookieStore cookieStore) {
        this.checkRequired();
        HttpRemoteTask<T> remoteTask = new HttpRemoteTask<T>();
        remoteTask.setDoubleTrust(this.doubleTrust);
        remoteTask.setContentCoder(this.contentCoder);
        remoteTask.setResponseData(responseData);
        if (simpleData != null && simpleData.size() > 0) {
            remoteTask.setSimpleData(simpleData);
        }
        return remoteTask.execute(this.baseUrl + methodName, jsonParameter, cookieStore);
    }

    private void checkRequired() {
        if (StringUtils.isEmpty((String)this.baseUrl)) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void setContentEncoder(AbstractByteCoder byteCoder) {
        this.contentCoder = byteCoder;
    }

    @Override
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Override
    public void setDoubleTrust(DoubleTrust doubleTrust) {
        this.doubleTrust = doubleTrust;
    }
}

