/*
 * Decompiled with CFR 0.152.
 */
package com.walker.remote.support;

import com.walker.infrastructure.utils.FileCopyUtils;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.remote.DoubleTrust;
import com.walker.remote.RemoteAccessorException;
import com.walker.remote.RemoteSyncTask;
import com.walker.remote.ResultData;
import com.walker.remote.util.HttpUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.util.Timeout;

public class HttpRemoteTask<T>
extends RemoteSyncTask<T> {
    private DoubleTrust doubleTrust;
    private CloseableHttpClient httpDoubleClient = null;
    private Timeout httpReadTimeout = Timeout.ofSeconds((long)60L);
    private RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(Timeout.ofSeconds((long)1L)).setConnectTimeout(Timeout.ofSeconds((long)30L)).setResponseTimeout(this.httpReadTimeout).build();
    private final Charset UTF8_CHAR_SET = Charset.forName("UTF-8");

    public Timeout getHttpReadTimeout() {
        return this.httpReadTimeout;
    }

    public void setHttpReadTimeout(Timeout httpReadTimeout) {
        this.httpReadTimeout = httpReadTimeout;
    }

    public void setDoubleTrust(DoubleTrust doubleTrust) {
        this.doubleTrust = doubleTrust;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String requestForData(Map<String, String> simpleData, String url, String jsonData, String methodType, String contentType, Map<String, String> header) throws RemoteAccessorException {
        boolean methodOfPost = true;
        CloseableHttpResponse response = null;
        CloseableHttpClient httpClient = null;
        if (this.doubleTrust == null) {
            httpClient = (CloseableHttpClient)HttpUtils.getInstance().getHttpClient();
        } else {
            if (this.httpDoubleClient == null) {
                this.httpDoubleClient = (CloseableHttpClient)HttpUtils.getInstance().getHttpDoubleTrustClient(this.doubleTrust, null);
                this.logger.debug(".............\u521b\u5efa\u4e86\u4e00\u4e2ahttps\u8fde\u63a5\uff1a" + this.doubleTrust);
            }
            httpClient = this.httpDoubleClient;
        }
        HttpGet get = null;
        HttpPost httpMethod = null;
        try {
            if (methodType != null && methodType.equals("GET") || simpleData == null && (jsonData == null || jsonData.equals(""))) {
                methodOfPost = false;
                get = new HttpGet(url);
                get.setConfig(this.requestConfig);
                if (StringUtils.isNotEmpty((String)contentType)) {
                    get.setHeader("Content-Type", (Object)contentType);
                }
                this.addHeader(header, (HttpUriRequestBase)get);
                response = httpClient.execute((ClassicHttpRequest)get);
            } else if (methodType != null) {
                if (methodType.equals("POST")) {
                    httpMethod = new HttpPost(url);
                } else if (methodType.equals("PUT")) {
                    httpMethod = new HttpPut(url);
                } else {
                    if (!methodType.equals("DELETE")) {
                        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u8bf7\u6c42\u65b9\u6cd5\uff1a" + methodType);
                    }
                    httpMethod = new HttpDelete(url);
                }
                httpMethod.setConfig(this.requestConfig);
                if (StringUtils.isNotEmpty((String)contentType)) {
                    httpMethod.setHeader("Content-Type", (Object)contentType);
                }
                this.addHeader(header, (HttpUriRequestBase)httpMethod);
                HttpPost httpRequest = httpMethod;
                List<NameValuePair> pair = null;
                Charset utf8 = Charset.forName("UTF-8");
                if (simpleData != null) {
                    pair = HttpUtils.doTranslatePairs(simpleData);
                    httpRequest.setEntity((HttpEntity)new UrlEncodedFormEntity(pair, utf8));
                }
                if (StringUtils.isNotEmpty((String)jsonData)) {
                    if (this.getContentCoder() != null) {
                        Object byteParams = jsonData.getBytes("UTF-8");
                        String enString = new String(this.getContentCoder().encrypt((byte[])byteParams));
                        this.logger.debug("---reuqest-----" + enString);
                        httpRequest.setEntity((HttpEntity)new StringEntity(enString, utf8));
                    } else {
                        httpRequest.setEntity((HttpEntity)new StringEntity(jsonData, utf8));
                    }
                }
                response = httpClient.execute((ClassicHttpRequest)httpMethod);
            }
            int statusCode = response.getCode();
            if (statusCode == 200) {
                HttpEntity entity = response.getEntity();
                if (entity == null) {
                    return null;
                }
                byte[] result = FileCopyUtils.copyToByteArray((InputStream)this.getInputStream((HttpResponse)response, entity));
                if (this.getContentCoder() == null) {
                    return new String(result, "UTF-8");
                }
                byte[] descrypt = this.getContentCoder().decrypt(result);
                return new String(descrypt, "UTF-8");
            }
            if (methodOfPost) {
                if (httpMethod == null) return null;
                httpMethod.abort();
                return null;
            } else {
                if (get == null) return null;
                get.abort();
            }
            return null;
        }
        catch (ClientProtocolException ce) {
            throw new RemoteAccessorException("httpClient\u534f\u8bae\u9519\u8bef", ce);
        }
        catch (IOException ioe) {
            throw new RemoteAccessorException("httpClient\u8fde\u63a5\u5f02\u5e38IO", ioe, true);
        }
        catch (Exception ex) {
            throw new RemoteAccessorException("httpClient\u8bf7\u6c42\u8f6c\u6362\u7ed3\u679c\u9519\u8bef\uff1acomputeResult()", ex);
        }
    }

    private void addHeader(Map<String, String> header, HttpUriRequestBase request) {
        if (header != null) {
            for (Map.Entry<String, String> entry : header.entrySet()) {
                request.setHeader(entry.getKey(), (Object)entry.getValue());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String requestForData(Map<String, String> simpleData, String url, String jsonData) throws RemoteAccessorException {
        boolean methodOfPost = true;
        CloseableHttpResponse response = null;
        CloseableHttpClient httpClient = null;
        if (this.doubleTrust == null) {
            httpClient = (CloseableHttpClient)HttpUtils.getInstance().getHttpClient();
        } else {
            if (this.httpDoubleClient == null) {
                this.httpDoubleClient = (CloseableHttpClient)HttpUtils.getInstance().getHttpDoubleTrustClient(this.doubleTrust, null);
                this.logger.debug(".............\u521b\u5efa\u4e86\u4e00\u4e2ahttps\u8fde\u63a5\uff1a" + this.doubleTrust);
            }
            httpClient = this.httpDoubleClient;
        }
        try {
            HttpGet get = null;
            HttpPost post = null;
            if (simpleData == null && (jsonData == null || jsonData.equals(""))) {
                methodOfPost = false;
                get = new HttpGet(url);
                get.setConfig(this.requestConfig);
                response = httpClient.execute((ClassicHttpRequest)get);
            } else {
                post = new HttpPost(url);
                post.setConfig(this.requestConfig);
                List<NameValuePair> pair = null;
                Charset utf8 = Charset.forName("UTF-8");
                if (simpleData != null) {
                    pair = HttpUtils.doTranslatePairs(simpleData);
                    post.setEntity((HttpEntity)new UrlEncodedFormEntity(pair, utf8));
                } else if (this.getContentCoder() != null) {
                    byte[] byteParams = jsonData.getBytes("UTF-8");
                    String enString = new String(this.getContentCoder().encrypt(byteParams));
                    this.logger.debug("---reuqest-----" + enString);
                    post.setEntity((HttpEntity)new StringEntity(enString, utf8));
                } else {
                    post.setEntity((HttpEntity)new StringEntity(jsonData, utf8));
                }
                response = httpClient.execute((ClassicHttpRequest)post);
            }
            int statusCode = response.getCode();
            if (statusCode == 200) {
                HttpEntity entity = response.getEntity();
                if (entity == null) {
                    return null;
                }
                byte[] result = FileCopyUtils.copyToByteArray((InputStream)this.getInputStream((HttpResponse)response, entity));
                if (this.getContentCoder() == null) return new String(result);
                byte[] descrypt = this.getContentCoder().decrypt(result);
                return new String(descrypt);
            }
            if (statusCode > 200 && statusCode <= 507) {
                HashMap<String, Integer> extendData = new HashMap<String, Integer>();
                extendData.put("code", statusCode);
                extendData.put("location", (Integer)response.getFirstHeader("Location"));
                return "ext//" + JsonUtils.objectToJsonString(extendData);
            }
            if (methodOfPost) {
                post.abort();
                this.logger.error("\u670d\u52a1\u8c03\u7528\u5b8c\u6210\uff0c\u4f46\u8fd4\u56de\u9519\u8bef\u4ee3\u7801\uff1a" + statusCode);
                return null;
            } else {
                get.abort();
                this.logger.error("\u670d\u52a1\u8c03\u7528\u5b8c\u6210\uff0c\u4f46\u8fd4\u56de\u9519\u8bef\u4ee3\u7801\uff1a" + statusCode);
            }
            return null;
        }
        catch (ClientProtocolException ce) {
            throw new RemoteAccessorException("httpClient\u534f\u8bae\u9519\u8bef", ce);
        }
        catch (IOException ioe) {
            throw new RemoteAccessorException("httpClient\u8fde\u63a5\u5f02\u5e38IO", ioe, true);
        }
        catch (Exception ex) {
            throw new RemoteAccessorException("httpClient\u8bf7\u6c42\u8f6c\u6362\u7ed3\u679c\u9519\u8bef\uff1acomputeResult()", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected ResultData requestForDataAndCookie(Map<String, String> simpleData, String url, String jsonData, CookieStore cookieStore) throws RemoteAccessorException {
        boolean methodOfPost = true;
        CloseableHttpResponse response = null;
        ResultData resultData = new ResultData();
        CloseableHttpClient httpClient = null;
        if (this.doubleTrust == null) {
            httpClient = (CloseableHttpClient)HttpUtils.getInstance().getHttpClientWithCookie(cookieStore);
        } else {
            if (this.httpDoubleClient == null) {
                this.httpDoubleClient = (CloseableHttpClient)HttpUtils.getInstance().getHttpDoubleTrustClient(this.doubleTrust, cookieStore);
                this.logger.debug(".............\u521b\u5efa\u4e86\u4e00\u4e2ahttps\u8fde\u63a5\uff1a" + this.doubleTrust);
            }
            httpClient = this.httpDoubleClient;
        }
        try {
            HttpGet get = null;
            HttpPost post = null;
            if (simpleData == null && (jsonData == null || jsonData.equals(""))) {
                methodOfPost = false;
                get = new HttpGet(url);
                get.setConfig(this.requestConfig);
                response = httpClient.execute((ClassicHttpRequest)get);
            } else {
                post = new HttpPost(url);
                post.setConfig(this.requestConfig);
                List<NameValuePair> pair = null;
                if (simpleData != null) {
                    pair = HttpUtils.doTranslatePairs(simpleData);
                    post.setEntity((HttpEntity)new UrlEncodedFormEntity(pair, this.UTF8_CHAR_SET));
                } else if (this.getContentCoder() != null) {
                    byte[] byteParams = jsonData.getBytes("UTF-8");
                    String enString = new String(this.getContentCoder().encrypt(byteParams));
                    this.logger.debug("---reuqest-----" + enString);
                    post.setEntity((HttpEntity)new StringEntity(enString, this.UTF8_CHAR_SET));
                } else {
                    post.setEntity((HttpEntity)new StringEntity(jsonData, this.UTF8_CHAR_SET));
                }
                response = httpClient.execute((ClassicHttpRequest)post);
            }
            int statusCode = response.getCode();
            if (statusCode == 200) {
                resultData.setCookiestore(cookieStore);
                HttpEntity entity = response.getEntity();
                if (entity == null) {
                    return null;
                }
                byte[] result = FileCopyUtils.copyToByteArray((InputStream)this.getInputStream((HttpResponse)response, entity));
                if (this.getContentCoder() != null) {
                    byte[] descrypt = this.getContentCoder().decrypt(result);
                    resultData.setHtml(new String(descrypt));
                    return resultData;
                } else {
                    resultData.setHtml(new String(result));
                }
                return resultData;
            }
            if (methodOfPost) {
                post.abort();
                this.logger.error("\u670d\u52a1\u8c03\u7528\u5b8c\u6210\uff0c\u4f46\u8fd4\u56de\u9519\u8bef\u4ee3\u7801\uff1a" + statusCode);
                return null;
            } else {
                get.abort();
                this.logger.error("\u670d\u52a1\u8c03\u7528\u5b8c\u6210\uff0c\u4f46\u8fd4\u56de\u9519\u8bef\u4ee3\u7801\uff1a" + statusCode);
            }
            return null;
        }
        catch (ClientProtocolException ce) {
            throw new RemoteAccessorException("httpClient\u534f\u8bae\u9519\u8bef", ce);
        }
        catch (IOException ioe) {
            throw new RemoteAccessorException("httpClient\u8fde\u63a5\u5f02\u5e38IO", ioe, true);
        }
        catch (Exception ex) {
            throw new RemoteAccessorException("httpClient\u8bf7\u6c42\u8f6c\u6362\u7ed3\u679c\u9519\u8bef\uff1acomputeResult()", ex);
        }
    }

    @Override
    protected void responseEmpty() {
        this.logger.debug(".......\u540c\u6b65http\u8c03\u7528\u8fd4\u56de\u7a7a\u6570");
    }

    private InputStream getInputStream(HttpResponse response, HttpEntity entity) throws Exception {
        InputStream is = entity.getContent();
        boolean gzip = false;
        if (response.containsHeader("Content-Encoding")) {
            String gzipStr = response.getHeaders("Content-Encoding")[0].getValue();
            boolean bl = gzip = gzipStr.equals("gzip");
        }
        if (gzip) {
            BufferedInputStream bis = new BufferedInputStream(is);
            bis.mark(2);
            byte[] header = new byte[2];
            int result = bis.read(header);
            bis.reset();
            int headerData = this.getShort(header);
            is = result != -1 && headerData == 8075 ? new GZIPInputStream(bis) : bis;
        }
        return is;
    }

    private int getShort(byte[] data) {
        return data[0] << 8 | data[1] & 0xFF;
    }
}

