package com.walker.remote;

import com.walker.infrastructure.core.NestedRuntimeException;

public class RemoteAccessorException extends NestedRuntimeException {

	/**
	 * 
	 */
	private static final long serialVersionUID = -4533512494265168359L;
	
	private boolean serverFailed = false;

	public boolean isServerFailed() {
		return serverFailed;
	}

	public RemoteAccessorException(){
		super("remote exception.");
	}
	
	public RemoteAccessorException(String msg){
		super(msg);
	}
	
	public RemoteAccessorException(String msg, Throwable cause){
		super(msg, cause);
	}
	
	public RemoteAccessorException(String msg, Throwable cause, boolean serverFailed){
		super(msg, cause);
		this.serverFailed = serverFailed;
	}
}
