package com.walker.remote;

import com.walker.api.client.ResponseData;
import com.walker.infrastructure.utils.StringUtils;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * 同步远程调用任务实现。
 * @author shikeying
 * @date 2015-9-2
 *
 */
public abstract class RemoteSyncTask<T> 
//implements ContextAware 
{

	private AbstractByteCoder contentCoder;
	
	protected Logger logger = LoggerFactory.getLogger(this.getClass());
	
	// 本次请求的简单参数，此参数优先处理，如果不存在才会处理其他参数
	private Map<String, String> simpleData;
	
	// 是否提示网络未连接状态，默认提示
//	private boolean showNetworkStatusTip = true;
	
	// 设置标记，是否服务端出现连接异常
	private boolean serverFailed = false;
	
	public boolean isServerFailed() {
		return serverFailed;
	}

	/**
	 * 返回简单的请求参数，此参数优先处理，如果不存在才会处理其他参数
	 * @return
	 */
	public Map<String, String> getSimpleData() {
		return simpleData;
	}
	
	protected AbstractByteCoder getContentCoder() {
		return contentCoder;
	}
	
	public void setSimpleData(Map<String, String> simpleData) {
		this.simpleData = simpleData;
	}

	public void setContext() {
//		this.context = context;
//		message = ToastMessage.getInstance(context);
	}
	
	public RemoteSyncTask<T> setContentCoder(AbstractByteCoder contentCoder) {
		this.contentCoder = contentCoder;
		return this;
	}
	
	public T execute(String url, String jsonData){
		if(StringUtils.isEmpty(url)){
			throw new RemoteAccessorException("缺少请求http调用参数");
		}
//		if(!AppUtils.isActiveConnected()){
//			return null;
//		}
		String result = null;
		try{
			result = requestForData(simpleData, url, jsonData);
		} catch(RemoteAccessorException e){
			e.printStackTrace();
			if(e.isServerFailed()){
				serverFailed = true;
				logger.debug("服务端连接异常");
			} else
				logger.debug(e.getMessage(), e);
		}
		
		if(result != null){
			return processDataUI(result);
		} else {
			responseEmpty();
			return null;
		}
	}
	
	public T execute(String url, String jsonData, CookieStore cookieStore){
		if(StringUtils.isEmpty(url)){
			throw new RemoteAccessorException("缺少请求http调用参数");
		}
		ResultData result = null;
		try{
			result = requestForDataAndCookie(simpleData, url, jsonData, cookieStore);
		} catch(RemoteAccessorException e){
			e.printStackTrace();
			if(e.isServerFailed()){
				serverFailed = true;
				logger.debug("服务端连接异常");
			} else
				logger.debug(e.getMessage(), e);
		}
		
		if(result != null){
			return processDataUI(result.getHtml());
		} else {
			responseEmpty();
			return null;
		}
	}
	
	public T execute(String url, Map<String, String> simpleData, String jsonData
			, String methodType, String contentType, Map<String, String> header){
		if(StringUtils.isEmpty(url)){
			throw new RemoteAccessorException("缺少请求http调用参数");
		}
		String result = null;
		try{
			result = requestForData(simpleData, url, jsonData, methodType, contentType, header);
		} catch(RemoteAccessorException e){
			e.printStackTrace();
			if(e.isServerFailed()){
				serverFailed = true;
				logger.debug("服务端连接异常");
			} else
				logger.debug(e.getMessage(), e);
		}
		
		if(result != null){
			return processDataUI(result);
		} else {
			responseEmpty();
			return null;
		}
	}
	
	/**
	 * 返回调用结果之后，回掉该函数，可以操作UI界面处理数据
	 * @param data
	 */
	protected T processDataUI(String data){
//		if(data instanceof String){
			String result = data.toString();
			if(!StringUtils.isEmpty(result)){
//				ResponseData<T> responseData = createResponseData(result);
				logger.debug("============= 执行了方法：createResponseData(),result = " + result);
				if(responseData == null){
					throw new IllegalStateException("please implementation createResponseData()!");
				}
				responseData.toObjectFromJson(result);
				
				if(!responseData.getStatus()){
					logger.debug(responseData.getMessage());
				}
				return (responseData.getResultData());
			}
//		} 
//		else if(data instanceof Uri){
//			// 对于图片等文件形式的内容，统一返回URI
////			Uri uri = (Uri)data;
////			success((T)uri);
//			throw new UnsupportedOperationException("不支持的数据返回类型：URI");
//			
//		} else if(data instanceof ResultDownload){
//			// 下载文件，返回特定对象
////			ResultDownload result = (ResultDownload)data;
////			success((T)result);
//			throw new UnsupportedOperationException("不支持的数据返回类型：ResultDownload");
//		}
		return null;
	}

	/**
	 * 具体的请求远程数据调用操作，由子类负责实现。
	 * @param simpleData 提交的简单参数
//	 * @param params 其他参数,params[0] = url, params[1] = json字符串参数
	 * @param url
	 * @param jsonData
	 * @return
	 */
	protected abstract String requestForData(Map<String, String> simpleData
			, String url, String jsonData) throws RemoteAccessorException;
	
	/**
	 * 时克英修改，增加更多请求参数，支持不同方法，如：put/post/delete等
	 * @param simpleData
	 * @param url
	 * @param jsonData
	 * @param contentType
	 * @param header
	 * @return
	 * @throws RemoteAccessorException
	 */
	protected abstract String requestForData(Map<String, String> simpleData
			, String url, String jsonData
			, String methodType, String contentType, Map<String, String> header) throws RemoteAccessorException;
	
	protected abstract ResultData requestForDataAndCookie(Map<String, String> simpleData
			, String url, String jsonData
			, CookieStore cookieStore) throws RemoteAccessorException;
	
	/**
	 * 响应返回空数据之后，调用该函数。
	 */
	protected abstract void responseEmpty();
	
	/**
	 * 创建一个特定的响应对象，该对象中包含的业务返回的pojo对象。
	 * @param jsonObj
	 * @return
	 */
//	protected abstract <T> ResponseData<T> createResponseData(String jsonObj);
	
	private ResponseData<T> responseData;
	public void setResponseData(ResponseData<T> responseData){
		this.responseData = responseData;
	}
}
