/*
 * Decompiled with CFR 0.152.
 */
package com.walker.remote.util;

import com.walker.remote.AbstractByteCoder;
import com.walker.remote.DoubleTrust;
import com.walker.remote.RemoteAccessor;
import com.walker.remote.RemoteAccessorException;
import com.walker.remote.support.DefaultRemoteAccessor;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.util.Timeout;
import org.springframework.core.io.ClassPathResource;

public class HttpUtils {
    private HttpClient httpClient = this.doCreateSafeHttpClient(null, null);
    private static HttpUtils httpUtils;

    private HttpUtils() {
    }

    public static HttpUtils getInstance() {
        if (httpUtils == null) {
            httpUtils = new HttpUtils();
        }
        return httpUtils;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public HttpClient getHttpClientWithCookie(CookieStore cookieStore) {
        return this.doCreateSafeHttpClient(null, cookieStore);
    }

    public HttpClient getHttpDoubleTrustClient(DoubleTrust doubleTrust, CookieStore cookieStore) {
        return this.doCreateSafeHttpClient(doubleTrust, cookieStore);
    }

    private HttpClient doCreateSafeHttpClient(DoubleTrust clientTrust, CookieStore cookieStore) {
        CloseableHttpClient httpclient = null;
        InputStream instream = null;
        ClassPathResource resource = null;
        KeyStore keyStore = null;
        PoolingHttpClientConnectionManager cm = null;
        try {
            resource = new ClassPathResource(clientTrust.getCerFilepath());
            instream = resource.getInputStream();
            keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(instream, clientTrust.getPassword().toCharArray());
        }
        catch (Exception ex) {
            throw new RemoteAccessorException("\u52a0\u8f7d\u8bc1\u4e66\u9519\u8bef: " + clientTrust.getCerFilepath(), ex);
        }
        try {
            SSLContext sslcontext = SSLContexts.custom().loadKeyMaterial(keyStore, clientTrust.getPassword().toCharArray()).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext, new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"}, null, (HostnameVerifier)new NoopHostnameVerifier());
            SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(Timeout.ofSeconds((long)10L)).build();
            cm = PoolingHttpClientConnectionManagerBuilder.create().setDefaultSocketConfig(socketConfig).setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
            cm.setDefaultMaxPerRoute(128);
            cm.setMaxTotal(512);
        }
        catch (Exception ex) {
            throw new RemoteAccessorException("SSLContext \u5f02\u5e38: " + ex.getMessage(), ex);
        }
        if (clientTrust != null) {
            try {
                httpclient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            finally {
                try {
                    instream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        httpclient = cookieStore != null ? HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setDefaultCookieStore(cookieStore).build() : HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
        return httpclient;
    }

    public static List<NameValuePair> doTranslatePairs(Map<String, String> simpleData) {
        ArrayList<NameValuePair> pair = new ArrayList<NameValuePair>();
        for (Map.Entry<String, String> entry : simpleData.entrySet()) {
            pair.add((NameValuePair)new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        return pair;
    }

    public static List<NameValuePair> doTranslatePairs(String json) {
        ArrayList<NameValuePair> pair = new ArrayList<NameValuePair>();
        pair.add((NameValuePair)new BasicNameValuePair("datas", json));
        return pair;
    }

    public RemoteAccessor getNewRemoteAccessor(String remoteURL, AbstractByteCoder contentCoder, DoubleTrust doubleTrust) {
        DefaultRemoteAccessor remoteAccessor = new DefaultRemoteAccessor();
        remoteAccessor.setBaseUrl(remoteURL);
        remoteAccessor.setContentEncoder(contentCoder);
        remoteAccessor.setDoubleTrust(doubleTrust);
        return remoteAccessor;
    }
}

