package com.walker.wxtools;

/**
 * 获取的微信用户信息对象。
 * @author 时克英
 * @date 2023-03-01
 */
public class WxUserInfo {

    public String getOpenid() {
        return openid;
    }

    public void setOpenid(String openid) {
        this.openid = openid;
    }

    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    /**
     * 用户的性别，值为1时是男性，值为2时是女性，值为0时是未知
     * @return
     */
    public int getSex() {
        return sex;
    }

    public void setSex(int sex) {
        this.sex = sex;
    }

    /**
     * 用户个人资料填写的省份
     * @return
     */
    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    /**
     * 国家，如中国为CN
     * @return
     */
    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    /**
     * 用户头像，最后一个数值代表正方形头像大小（有0、46、64、96、132数值可选，0代表640*640正方形头像），用户没有头像时该项为空。<p><p/>
     * 若用户更换头像，原有头像 URL 将失效。<p></p>
     * https://thirdwx.qlogo.cn/mmopen/g3MonUZtNHkdmzicIlibx6iaFqAc56vxLSUfpb6n5WKSYVY0ChQKkiaJSgQ1dZuTOgvLLrhJbERQQ4eMsv84eavHiaiceqxibJxCfHe/46
     * @return
     */
    public String getHeadimgurl() {
        return headimgurl;
    }

    public void setHeadimgurl(String headimgurl) {
        this.headimgurl = headimgurl;
    }

    /**
     * 用户特权信息，json 数组，如微信沃卡用户为（chinaunicom）<p></p>
     * [ "PRIVILEGE1" "PRIVILEGE2"     ]
     * @return
     */
    public String getPrivilege() {
        return privilege;
    }

    public void setPrivilege(String privilege) {
        this.privilege = privilege;
    }

    /**
     * 只有在用户将公众号绑定到微信开放平台帐号后，才会出现该字段。
     * @return
     */
    public String getUnionid() {
        return unionid;
    }

    public void setUnionid(String unionid) {
        this.unionid = unionid;
    }

    /**
     * 是否关注公众号，需要测试该属性是否存在。
     * @return
     * @date 2023-04-20
     */
    public int getSubscribe() {
        return subscribe;
    }

    public void setSubscribe(int subscribe) {
        this.subscribe = subscribe;
    }

    private int subscribe = 0;
    private String openid;
    private String nickname;
    private int sex = 0;
    private String province;
    private String city;
    private String country;
    private String headimgurl;
    private String privilege;
    private String unionid;

}
