package com.walker.wxtools.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessTokenUtils {

    private static final Logger logger = LoggerFactory.getLogger(AccessTokenUtils.class);

    /**
     * 判断缓存access_token是否过期。
     * @param accessTokenCreateTime 创建时间，毫秒值
     * @param maxCachedSeconds 最大缓存时间，秒
     * @return
     */
    public static final boolean isExpiredCache(long accessTokenCreateTime, long maxCachedSeconds){
        long spanSeconds = (System.currentTimeMillis() - accessTokenCreateTime) / 1000;
        if(spanSeconds >= maxCachedSeconds){
            logger.warn("access_token缓存已过期，需要重新计算");
            return true;
        }
        return false;
    }
}
