/*
 * Decompiled with CFR 0.152.
 */
package com.walker.wxtools;

import com.walker.infrastructure.utils.StringUtils;
import com.walker.wxtools.AccessTokenNotFoundException;
import com.walker.wxtools.BasicAccessToken;
import com.walker.wxtools.JsTicket;
import com.walker.wxtools.OfficialAccountEngine;
import com.walker.wxtools.WxRemoteException;
import com.walker.wxtools.WxUserInfo;
import com.walker.wxtools.util.AccessTokenUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOfficialAccountEngine
implements OfficialAccountEngine {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private long maxCachedAccessTokenSeconds = 5400L;
    private String appId;
    private String secret;

    @Override
    public WxUserInfo getUserInfoSub(String openId) throws AccessTokenNotFoundException {
        String basicAccessToken = null;
        try {
            basicAccessToken = this.getBasicAccessToken();
            if (StringUtils.isEmpty((String)basicAccessToken)) {
                throw new Exception("basicAccessToken\u4e3a\u7a7a", null);
            }
        }
        catch (Exception ex) {
            throw new AccessTokenNotFoundException(ex.getMessage(), ex);
        }
        try {
            return this.acquireRemoteUserInfoSub(openId, basicAccessToken);
        }
        catch (WxRemoteException e) {
            throw new RuntimeException("\u8fdc\u7a0b\u8c03\u7528'\u83b7\u53d6\u5fae\u4fe1\u7528\u6237\u63a5\u53e3'\u5931\u8d25:" + e.getError(), (Throwable)((Object)e));
        }
    }

    @Override
    public WxUserInfo getUserInfo(String openId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getAuthAccessToken(String code) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getJsApiTicket() {
        String basicAccessToken = this.getBasicAccessToken();
        if (StringUtils.isEmpty((String)basicAccessToken)) {
            this.logger.error("getJsApiTicket:\u83b7\u53d6'basicAccessToken'\u4e3a\u7a7a!");
            return null;
        }
        return this.getJsApiTicket(basicAccessToken);
    }

    @Override
    public String getJsApiTicket(String basicAccessToken) {
        JsTicket jsTicket = this.acquireCachedJsTicket("js_ticket:" + this.getAppId());
        if (jsTicket != null && !AccessTokenUtils.isExpiredCache(jsTicket.getCreateTime(), this.maxCachedAccessTokenSeconds)) {
            return jsTicket.getTicket();
        }
        try {
            jsTicket = this.acquireRemoteJsTicket(basicAccessToken);
            this.logger.debug("\u8fdc\u7a0b\u83b7\u53d6'jsTicket'..........{}", (Object)jsTicket);
            this.writeJsTicketToCache("js_ticket:" + this.getAppId(), jsTicket);
            return jsTicket.getTicket();
        }
        catch (WxRemoteException e) {
            throw new RuntimeException(e.getError(), (Throwable)((Object)e));
        }
    }

    @Override
    public String getJsApiTicket4Card(String basicAccessToken) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getBasicAccessToken() {
        BasicAccessToken accessToken = this.acquireCachedBasicAccessToken("access_token:" + this.getAppId());
        if (accessToken != null && !AccessTokenUtils.isExpiredCache(accessToken.getCreateTime(), this.maxCachedAccessTokenSeconds)) {
            return accessToken.getAccessToken();
        }
        try {
            accessToken = this.acquireRemoteBasicAccessToken(this.getAppId(), this.getSecret());
            this.logger.debug("\u8fdc\u7a0b\u83b7\u53d6'access_token'..........{}", (Object)accessToken);
            this.writeBasicAccessTokenToCache("access_token:" + this.getAppId(), accessToken);
            return accessToken.getAccessToken();
        }
        catch (WxRemoteException e) {
            throw new RuntimeException(e.getError(), (Throwable)((Object)e));
        }
    }

    protected abstract JsTicket acquireCachedJsTicket(String var1);

    protected abstract void writeJsTicketToCache(String var1, JsTicket var2);

    protected abstract JsTicket acquireRemoteJsTicket(String var1) throws WxRemoteException;

    protected abstract BasicAccessToken acquireCachedBasicAccessToken(String var1);

    protected abstract void writeBasicAccessTokenToCache(String var1, BasicAccessToken var2);

    protected abstract BasicAccessToken acquireRemoteBasicAccessToken(String var1, String var2) throws WxRemoteException;

    protected abstract WxUserInfo acquireRemoteUserInfoSub(String var1, String var2) throws WxRemoteException;

    @Override
    public void setAppId(String appId) {
        if (StringUtils.isEmpty((String)appId)) {
            throw new IllegalArgumentException("'appId'\u5fc5\u987b\u63d0\u4f9b");
        }
        this.appId = appId;
    }

    @Override
    public void setSecret(String secret) {
        if (StringUtils.isEmpty((String)secret)) {
            throw new IllegalArgumentException("'secret'\u5fc5\u987b\u63d0\u4f9b");
        }
        this.secret = secret;
    }

    @Override
    public String getAppId() {
        return this.appId;
    }

    protected String getSecret() {
        return this.secret;
    }

    public long getMaxCachedAccessTokenSeconds() {
        return this.maxCachedAccessTokenSeconds;
    }

    public void setMaxCachedAccessTokenSeconds(long maxCachedAccessTokenSeconds) {
        this.maxCachedAccessTokenSeconds = maxCachedAccessTokenSeconds;
    }
}

