/*
 * Decompiled with CFR 0.152.
 */
package com.walker.wxtools.spider;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.wxtools.AccountArticle;
import com.walker.wxtools.spider.RequestException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class AccountArticleSpider {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private String cookie;
    private String referer;
    private String fakeId;
    private String token;
    private int begin = 0;
    private int count = 5;
    private RestTemplate restTemplate;
    private static final String URL = "https://mp.weixin.qq.com/cgi-bin/appmsg?action=list_ex&lang=zh_CN&f=json&ajax=1&type=9&query=";

    public List<AccountArticle> request() throws RequestException {
        HttpHeaders headers = new HttpHeaders();
        headers.add("accept", "*/*");
        headers.add("accept-language", "zh-CN,zh;q=0.9,en;q=0.8");
        headers.add("user-agent", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36");
        headers.add("x-requested-with", "XMLHttpRequest");
        headers.add("cookie", this.cookie);
        headers.add("referer", this.referer);
        HttpEntity request = new HttpEntity(null, (MultiValueMap)headers);
        StringBuilder urlObj = new StringBuilder(URL);
        urlObj.append("&").append("fakeid=").append(this.fakeId);
        urlObj.append("&").append("token=").append(this.token);
        urlObj.append("&").append("begin=").append(this.begin);
        urlObj.append("&").append("count=").append(this.count);
        try {
            ResponseEntity response = this.restTemplate.exchange(urlObj.toString(), HttpMethod.GET, request, String.class, new Object[0]);
            if (response.getStatusCodeValue() == 200) {
                this.logger.info("\u6210\u529f\u6293\u53d6\u4e00\u6b21: " + (String)response.getBody());
                ObjectNode data = JsonUtils.jsonStringToObjectNode((String)((String)response.getBody()));
                JsonNode baseResp = data.get("base_resp");
                int ret = baseResp.get("ret").intValue();
                this.logger.info("-----------> ret = " + ret);
                if (ret != 0) {
                    this.logger.warn("\u6ca1\u6709\u8fd4\u56de\u6570\u636e\uff0c\u8bf4\u660e\u8fd4\u56de\u7684\u5f02\u5e38\u54cd\u5e94:{}", (Object)baseResp.textValue());
                    throw new RequestException(true, (String)response.getBody(), null);
                }
                if (data.get("app_msg_cnt").intValue() <= 0) {
                    this.logger.info("app_msg_cnt <= 0\uff0c\u6ca1\u6709\u8fd4\u56de\u4efb\u4f55\u6570\u636e");
                    return null;
                }
                String arrays = data.get("app_msg_list").toString();
                this.logger.debug(arrays);
                ArrayNode arrayNode = JsonUtils.toJsonArray((String)arrays);
                ArrayList<AccountArticle> resulList = new ArrayList<AccountArticle>(8);
                if (arrayNode != null && arrayNode.size() > 0) {
                    JsonNode jsonNode = null;
                    AccountArticle article = null;
                    for (int i = 0; i < arrayNode.size(); ++i) {
                        jsonNode = arrayNode.get(i);
                        article = new AccountArticle();
                        article.setAid(jsonNode.get("aid").asText());
                        article.setTitle(jsonNode.get("title").asText());
                        article.setLink(jsonNode.get("link").textValue());
                        article.setCover(jsonNode.get("cover").textValue());
                        article.setUpdateTime(jsonNode.get("update_time").longValue());
                        article.setAppmsgid(jsonNode.get("appmsgid").textValue());
                        resulList.add(article);
                    }
                }
                return resulList;
            }
            this.logger.error("\u8c03\u7528\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\u5931\u8d25\uff0ccode = " + response.getStatusCodeValue());
            throw new RequestException(true, response.getStatusCodeValue() + ":" + (String)response.getBody(), null);
        }
        catch (Exception ex) {
            this.logger.error("\u8bf7\u6c42\u8c03\u7528\u63a5\u53e3\u9519\u8bef:" + ex.getMessage(), (Throwable)ex);
            throw new RequestException(false, ex.getMessage(), ex);
        }
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public void setFakeId(String fakeId) {
        this.fakeId = fakeId;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setBegin(int begin) {
        this.begin = begin;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setCookie(String cookie) {
        this.cookie = cookie;
    }

    public void setReferer(String referer) {
        this.referer = referer;
    }
}

