/*
 * Decompiled with CFR 0.152.
 */
package com.walker.wxtools.support;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.wxtools.AbstractOfficialAccountEngine;
import com.walker.wxtools.BasicAccessToken;
import com.walker.wxtools.JsTicket;
import com.walker.wxtools.WxRemoteException;
import com.walker.wxtools.WxUserInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.web.client.RestTemplate;

public class DefaultOfficialAccountEngine
extends AbstractOfficialAccountEngine {
    private final Map<String, JsTicket> innerJsTicketCache = new ConcurrentHashMap<String, JsTicket>(8);
    private final Map<String, BasicAccessToken> innerAccessTokenCache = new ConcurrentHashMap<String, BasicAccessToken>(8);
    private RestTemplate restTemplate;

    @Override
    protected JsTicket acquireCachedJsTicket(String cacheKey) {
        return this.innerJsTicketCache.get(cacheKey);
    }

    @Override
    protected void writeJsTicketToCache(String cacheKey, JsTicket jsTicket) {
        if (this.innerJsTicketCache.get(cacheKey) != null) {
            this.innerJsTicketCache.remove(cacheKey);
        }
        this.innerJsTicketCache.put(cacheKey, jsTicket);
        this.logger.info("\u5199\u5165'jsTicket'\u7f13\u5b58");
    }

    @Override
    protected JsTicket acquireRemoteJsTicket(String basicAccessToken) throws WxRemoteException {
        this.checkRestTemplate();
        HashMap<String, String> paramMap = new HashMap<String, String>(4);
        paramMap.put("type", "jsapi");
        paramMap.put("access_token", basicAccessToken);
        try {
            ObjectNode objectNode;
            String entity = (String)this.restTemplate.getForObject("https://api.weixin.qq.com/cgi-bin/ticket/getticket", String.class, paramMap);
            if (entity == null) {
                throw new RuntimeException("\u8c03\u7528'jsTicket'\u8fd4\u56de\u7a7a\u6570\u636e, basicAccessToken = " + basicAccessToken);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(entity);
            }
            if ((objectNode = JsonUtils.jsonStringToObjectNode((String)entity)).get("errcode").intValue() != 0) {
                throw new WxRemoteException(objectNode.get("errmsg").asText(), "\u5fae\u4fe1\u83b7\u53d6'jsTicket'\u8fd4\u56de\u9519\u8bef", null);
            }
            JsTicket jsTicket = new JsTicket();
            jsTicket.setTicket(objectNode.get("ticket").asText());
            jsTicket.setExpireSeconds(objectNode.get("expires_in").longValue());
            jsTicket.setCreateTime(System.currentTimeMillis());
            return jsTicket;
        }
        catch (Exception ex) {
            StringBuilder error = new StringBuilder("\u5fae\u4fe1\u8fdc\u7a0b\u83b7\u53d6'jsTicket'\u5931\u8d25, basicAccessToken=").append(basicAccessToken);
            if (ex instanceof WxRemoteException) {
                WxRemoteException wex = (WxRemoteException)((Object)ex);
                throw wex;
            }
            error.append(", error = ").append(ex.getMessage());
            throw new WxRemoteException(error.toString(), ex.getMessage(), ex);
        }
    }

    @Override
    protected BasicAccessToken acquireCachedBasicAccessToken(String cacheKey) {
        return this.innerAccessTokenCache.get(cacheKey);
    }

    @Override
    protected void writeBasicAccessTokenToCache(String cacheKey, BasicAccessToken basicAccessToken) {
        if (this.innerAccessTokenCache.get(cacheKey) != null) {
            this.innerAccessTokenCache.remove(cacheKey);
        }
        this.innerAccessTokenCache.put(cacheKey, basicAccessToken);
        this.logger.info("\u5199\u5165'basicAccessToken'\u7f13\u5b58");
    }

    @Override
    protected BasicAccessToken acquireRemoteBasicAccessToken(String appId, String secret) throws WxRemoteException {
        this.checkRestTemplate();
        HashMap<String, String> paramMap = new HashMap<String, String>(4);
        paramMap.put("appid", appId);
        paramMap.put("secret", secret);
        paramMap.put("grant_type", "client_credential");
        try {
            ObjectNode objectNode;
            String entity = (String)this.restTemplate.getForObject("https://api.weixin.qq.com/cgi-bin/token", String.class, paramMap);
            if (entity == null) {
                throw new RuntimeException("\u8c03\u7528'BasicAccessToken'\u8fd4\u56de\u7a7a\u6570\u636e, appId = " + appId);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(entity);
            }
            if ((objectNode = JsonUtils.jsonStringToObjectNode((String)entity)).has("errcode")) {
                throw new WxRemoteException(objectNode.get("errmsg").asText(), "\u5fae\u4fe1\u83b7\u53d6'BasicAccessToken'\u8fd4\u56de\u9519\u8bef", null);
            }
            BasicAccessToken basicAccessToken = new BasicAccessToken();
            basicAccessToken.setAccessToken(objectNode.get("access_token").asText());
            basicAccessToken.setExpireSeconds(objectNode.get("expires_in").longValue());
            basicAccessToken.setCreateTime(System.currentTimeMillis());
            return basicAccessToken;
        }
        catch (Exception ex) {
            StringBuilder error = new StringBuilder("\u5fae\u4fe1\u8fdc\u7a0b\u83b7\u53d6'BasicAccessToken'\u5931\u8d25, appId=");
            error.append(appId);
            if (ex instanceof WxRemoteException) {
                WxRemoteException wex = (WxRemoteException)((Object)ex);
                error.append(", error = ").append(wex.getError());
            }
            throw new WxRemoteException(error.toString(), ex.getMessage(), ex);
        }
    }

    @Override
    protected WxUserInfo acquireRemoteUserInfoSub(String openId, String basicAccessToken) throws WxRemoteException {
        this.checkRestTemplate();
        HashMap<String, String> paramMap = new HashMap<String, String>(4);
        paramMap.put("access_token", basicAccessToken);
        paramMap.put("openid", openId);
        paramMap.put("lang", "zh_CN");
        try {
            String entity = (String)this.restTemplate.getForObject("https://api.weixin.qq.com/cgi-bin/user/info", String.class, paramMap);
            if (entity == null) {
                throw new RuntimeException("\u8c03\u7528'userInfoSub'\u8fd4\u56de\u7a7a\u6570\u636e, openId = " + openId + ", access_token=" + basicAccessToken);
            }
            ObjectNode objectNode = JsonUtils.jsonStringToObjectNode((String)entity);
            if (objectNode.has("errcode")) {
                throw new WxRemoteException(objectNode.get("errmsg").asText(), "\u5fae\u4fe1\u83b7\u53d6'userInfoSub'\u8fd4\u56de\u9519\u8bef", null);
            }
            WxUserInfo userInfo = (WxUserInfo)JsonUtils.jsonStringToObject((String)entity, WxUserInfo.class);
            return userInfo;
        }
        catch (Exception ex) {
            StringBuilder error = new StringBuilder("\u5fae\u4fe1\u8fdc\u7a0b\u83b7\u53d6'userInfoSub'\u5931\u8d25, openId=");
            error.append(openId);
            if (ex instanceof WxRemoteException) {
                WxRemoteException wex = (WxRemoteException)((Object)ex);
                throw wex;
            }
            error.append(", error = ").append(ex.getMessage());
            throw new WxRemoteException(error.toString(), ex.getMessage(), ex);
        }
    }

    private void checkRestTemplate() {
        if (this.restTemplate == null) {
            throw new IllegalArgumentException("RestTemplate\u672a\u914d\u7f6e!");
        }
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }
}

