package com.walker.wxtools;

import java.io.Serializable;

/**
 * 基础的'access_token'对象，从微信远程获取（创建）的。
 * @date 2023-04-20
 */
public class BasicAccessToken implements Serializable {

    @Override
    public String toString(){
        return new StringBuilder("[accessToken=").append(this.accessToken)
                .append(", expireSeconds=").append(this.expireSeconds)
                .append(", createTime=").append(this.createTime)
                .append("]").toString();
    }

    public String getAccessToken() {
        return accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public long getExpireSeconds() {
        return expireSeconds;
    }

    public void setExpireSeconds(long expireSeconds) {
        this.expireSeconds = expireSeconds;
    }

    public long getCreateTime() {
        return createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    private String accessToken;
    private long expireSeconds = 0;
    private long createTime = System.currentTimeMillis();
}
