package com.walker.wxtools;

/**
 * 微信公众号引擎定义。
 * @author 时克英
 * @date 2023-02-27
 */
public interface OfficialAccountEngine {

    /**
     * 公众号关注后，可通过该方法获取用户基本信息。
     * @param openId 指定获取的用户标识
//     * @param basicAccessToken 基本'access_token'
     * @return
     * @date 2023-04-20
     */
    public WxUserInfo getUserInfoSub(String openId) throws AccessTokenNotFoundException;

    /**
     * 获得微信用户基本信息。
     * <pre>
     * 1) 拉取用户信息(需 scope 为 snsapi_userinfo)
     * 如果网页授权作用域为snsapi_userinfo，则此时开发者可以通过access_token和 openid 拉取用户信息
     * </pre>
     * @param openId
     * @return
     */
    WxUserInfo getUserInfo(String openId);

    /**
     * 通过 code 换取网页授权access_token。
     * <pre>
     * 1) 首先请注意，这里通过 code 换取的是一个特殊的网页授权access_token,与基础支持中的access_token（该access_token用于调用其他接口）不同。
     * 2) 公众号可通过下述接口来获取网页授权access_token。
     * 3) 如果网页授权的作用域为snsapi_base，则本步骤中获取到网页授权access_token的同时，也获取到了openid，snsapi_base式的网页授权流程即到此为止。
     * </pre>
     * @param code
     * @return
     */
    String getAuthAccessToken(String code);

    /**
     * 获得jsapi_ticket: 是公众号用于调用微信JS接口的临时票据.<p></p>
     * access_token 参数由引擎自动获取。
     * <pre>
     * {
     * "errcode":0,
     * "errmsg":"ok",
     * "ticket":"bxLdikRXVbTPdHSM05e5u5sUoXNKd8-41ZO3MhKoyN5OfkWITDGgnr2fwJ0m9E8NYzWKVZvdVtaUgWvsdshFKA",
     * "expires_in":7200
     * }
     * </pre>
     * @return
     */
    String getJsApiTicket();

    /**
     * 同方法: {@linkplain OfficialAccountEngine#getJsApiTicket()}。
     * @param basicAccessToken 从外部提供参数: access_token
     * @return
     */
    String getJsApiTicket(String basicAccessToken);

    /**
     * 提供卡卷类型的 jsapi_ticket
     * @param basicAccessToken 从外部提供参数: access_token
     * @return
     */
    String getJsApiTicket4Card(String basicAccessToken);

    /**
     * 获得公众号基础的 access_token。
     * <pre>
     *     access_token是公众号的全局唯一接口调用凭据，公众号调用各接口时都需使用access_token。
     *     开发者需要进行妥善保存。access_token的存储至少要保留512个字符空间。
     *     access_token的有效期目前为2个小时，需定时刷新，重复获取将导致上次获取的access_token失效。
     * </pre>
     * @return
     */
    String getBasicAccessToken();

    void setAppId(String appId);

    void setSecret(String secret);

    /**
     * 返回appId，用于标识该引擎对应哪个公众号，为业务多个配置做区分。
     * @return
     * @date 2023-04-20
     */
    String getAppId();
}
