package com.walker.wxtools.push;

import com.walker.push.AbstractPushObject;
import com.walker.push.Notification;
import com.walker.push.NotificationChannel;
import com.walker.push.PushException;
import com.walker.push.PushResult;
import com.walker.push.util.PushUtils;
import com.walker.wxtools.WxTemplateMessage;

import java.util.List;

/**
 * 公众号推送实现。同步调用
 * @author 时克英
 * @date 2023-04-21
 */
public class OfficialAccountPush extends AbstractPushObject<WxTemplateMessage> {

    public OfficialAccountPush(){
        this.setId(NotificationChannel.OfficialAccount.getIndex());
        this.setName(NotificationChannel.OfficialAccount.getName() + "推送");
    }

    @Override
    protected PushResult doPushContent(Notification notification, List<WxTemplateMessage> data) throws PushException {
        logger.debug("公众号推送消息:{}", notification);
        return PushUtils.acquireSuccessPushResult();
    }

    @Override
    public NotificationChannel getNotificationChannel() {
        return NotificationChannel.OfficialAccount;
    }

    @Override
    public List<WxTemplateMessage> translateToTarget(Notification notification) {
        return null;
    }

    @Override
    public void startup() {

    }
}
