/*
 * Decompiled with CFR 0.152.
 */
package com.walker.wxtools.spider;

import com.walker.infrastructure.utils.KeyValue;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.spider.KeyValueParse;
import com.walker.wxtools.AccountArticle;
import com.walker.wxtools.spider.AccountArticleSpider;
import com.walker.wxtools.spider.RequestException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestTemplate;

public class MockSpiderScheduler {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private int responseErrorCount = 0;
    private static final long sleepSeconds = 120L;
    private static final long stopSeconds = 1200L;
    private long sleepTime = 120L;
    private int currentPage = 0;
    private int resetPageSize = 5;
    private Thread thread = null;
    private boolean stop = false;
    private RestTemplate restTemplate = null;
    private AccountArticleSpider spider = null;
    private KeyValueParse keyValueParse;
    private List<String> wantedKeys = new ArrayList<String>(8);
    public static final String KEY_COOKIE = "cookie";
    public static final String KEY_REFERER = "referer";
    public static final String KEY_FAKEID = "fakeid";
    public static final String KEY_TOKEN = "token";

    public MockSpiderScheduler() {
        this.wantedKeys.add(KEY_COOKIE);
        this.wantedKeys.add(KEY_REFERER);
        this.wantedKeys.add(KEY_FAKEID);
        this.wantedKeys.add(KEY_TOKEN);
        this.restTemplate = new RestTemplate();
    }

    @Deprecated
    private void scheduleRequest() {
        try {
            this.spider.request();
        }
        catch (RequestException e) {
            if (e.isResponseError()) {
                if (this.responseErrorCount >= 10) {
                    this.responseErrorCount = 0;
                }
                this.logger.error("\u8bf7\u6c42\u54cd\u5e94\u9519\u8bef\uff0c\u5f88\u53ef\u80fd\u662fcookie\u8fc7\u671f\uff0c\u63d0\u9192\u7528\u6237\u91cd\u65b0\u83b7\u53d6\u767b\u5f55\u4fe1\u606f\u3002msg=" + e.getMessage(), (Throwable)e);
                ++this.responseErrorCount;
                if (this.responseErrorCount > 2) {
                    this.cookieExpired();
                }
            }
            this.logger.error("\u8fdc\u7a0b\u8c03\u7528\u5176\u5b83\u9519\u8bef\uff0c\u5f88\u53ef\u80fd\u662f\u7f51\u7edc\u95ee\u9898\uff0c\u9700\u8981\u5c1d\u8bd5\u91cd\u8bd5\uff0cmsg=" + e.getMessage(), (Throwable)e);
        }
    }

    protected void cookieExpired() {
        this.logger.info("\u901a\u77e5\u7528\u6237\u91cd\u65b0\u767b\u5f55\uff0c\u5e76\u63d0\u4ea4cookie\u4fe1\u606f");
    }

    protected void saveData(List<AccountArticle> list) {
        if (!StringUtils.isEmptyList(list)) {
            this.logger.info("\u91c7\u96c6\u5230\u6570\u91cf:" + list.size());
            this.logger.info("\u6570\u636e\u5e93\u4fdd\u5b58\u5f00\u59cb...");
            for (AccountArticle article : list) {
                this.logger.info(article.toString());
            }
        } else {
            this.logger.warn("\u91c7\u96c6\u6210\u529f\u4e00\u6b21\uff0c\u4f46\u7a7a\u6570\u636e");
        }
    }

    public void setCookieAndParameter(String content, String delimiter) {
        if (StringUtils.isEmpty((String)delimiter)) {
            delimiter = "\n";
        }
        this.keyValueParse = new KeyValueParse();
        this.keyValueParse.setDelimiter(delimiter);
        List list = this.keyValueParse.parse((Object)content, this.wantedKeys);
        if (list == null || list.size() == 0) {
            throw new IllegalArgumentException("\u672a\u89e3\u6790\u51fa\u6765\u4efb\u4f55\u8bf7\u6c42\u53c2\u6570! content=" + content);
        }
        String fakeId = null;
        String token = null;
        int count = 5;
        String cookie = null;
        String referer = null;
        for (KeyValue kv : list) {
            if (((String)kv.getKey()).equals(KEY_COOKIE)) {
                cookie = (String)kv.getValue();
                continue;
            }
            if (((String)kv.getKey()).equals(KEY_FAKEID)) {
                fakeId = (String)kv.getValue();
                continue;
            }
            if (((String)kv.getKey()).equals(KEY_REFERER)) {
                referer = (String)kv.getValue();
                continue;
            }
            if (!((String)kv.getKey()).equals(KEY_TOKEN)) continue;
            token = (String)kv.getValue();
        }
        if (StringUtils.isEmpty(fakeId) || StringUtils.isEmpty(token) || StringUtils.isEmpty(cookie) || StringUtils.isEmpty(referer)) {
            throw new IllegalArgumentException("\u89e3\u6790\u8fd4\u56de\u53c2\u6570\u4e0d\u8db3\uff0c\u65e0\u6cd5\u5b8c\u6210\u8c03\u7528\u3002");
        }
        this.spider = new AccountArticleSpider();
        this.spider.setRestTemplate(this.restTemplate);
        this.spider.setFakeId(fakeId);
        this.spider.setToken(token);
        this.spider.setCount(count);
        this.spider.setBegin(this.currentPage);
        this.spider.setCookie(cookie);
        this.spider.setReferer(referer);
        if (this.thread == null) {
            this.logger.info("\u521b\u5efa\u7ebf\u7a0b...");
            this.thread = new Thread(new GatherTask());
            this.thread.start();
        }
    }

    public void terminate() {
        this.stop = true;
    }

    private class GatherTask
    implements Runnable {
        private Random random = new Random(100L);

        private GatherTask() {
        }

        @Override
        public void run() {
            MockSpiderScheduler.this.logger.info("............\u7ebf\u7a0b\u542f\u52a8\uff1a" + new Date());
            while (!MockSpiderScheduler.this.stop) {
                try {
                    List<AccountArticle> list = MockSpiderScheduler.this.spider.request();
                    MockSpiderScheduler.this.saveData(list);
                    MockSpiderScheduler.this.sleepTime = 120L;
                    MockSpiderScheduler.this.logger.info("\u91c7\u96c6\u7b2c {} \u9875\u5b8c\u6210", (Object)MockSpiderScheduler.this.currentPage);
                    ++MockSpiderScheduler.this.currentPage;
                    if (MockSpiderScheduler.this.currentPage >= MockSpiderScheduler.this.resetPageSize) {
                        MockSpiderScheduler.this.logger.debug("\u8fbe\u5230\u89e6\u53d1\u9875\u6570\uff0c\u590d\u4f4d\u91cd\u65b0\u5f00\u59cb\u91c7\u96c6\uff08\u6700\u65b0\u7684\uff09");
                        MockSpiderScheduler.this.currentPage = 0;
                    }
                    MockSpiderScheduler.this.spider.setBegin(MockSpiderScheduler.this.currentPage);
                }
                catch (RequestException e) {
                    if (e.isResponseError()) {
                        if (MockSpiderScheduler.this.responseErrorCount >= 10) {
                            MockSpiderScheduler.this.responseErrorCount = 0;
                        }
                        MockSpiderScheduler.this.logger.error("\u8bf7\u6c42\u54cd\u5e94\u9519\u8bef\uff0c\u5f88\u53ef\u80fd\u662fcookie\u8fc7\u671f\uff0c\u63d0\u9192\u7528\u6237\u91cd\u65b0\u83b7\u53d6\u767b\u5f55\u4fe1\u606f\u3002msg=" + e.getMessage(), (Throwable)e);
                        ++MockSpiderScheduler.this.responseErrorCount;
                        if (MockSpiderScheduler.this.responseErrorCount <= 2) continue;
                        MockSpiderScheduler.this.cookieExpired();
                        MockSpiderScheduler.this.sleepTime = 1200L;
                        continue;
                    }
                    MockSpiderScheduler.this.logger.error("\u8fdc\u7a0b\u8c03\u7528\u5176\u5b83\u9519\u8bef\uff0c\u5f88\u53ef\u80fd\u662f\u7f51\u7edc\u95ee\u9898\uff0c\u9700\u8981\u5c1d\u8bd5\u91cd\u8bd5\uff0cmsg=" + e.getMessage(), (Throwable)e);
                }
                catch (Exception ex) {
                    MockSpiderScheduler.this.logger.error("\u5176\u4ed6\u5f02\u5e38\uff0c\u53ef\u80fd\u6570\u636e\u4fdd\u5b58\u9519\u8bef:" + ex.getMessage(), (Throwable)ex);
                }
                finally {
                    int rnd = this.random.nextInt(10);
                    if (rnd == 0) {
                        rnd = 2;
                    }
                    try {
                        MockSpiderScheduler.this.logger.debug("\u7ebf\u7a0b\u4f11\u7720 {} \u79d2", (Object)(MockSpiderScheduler.this.sleepTime * (long)rnd));
                        TimeUnit.SECONDS.sleep(MockSpiderScheduler.this.sleepTime * (long)rnd);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            MockSpiderScheduler.this.logger.warn("\u91c7\u96c6\u7ebf\u7a0b\u7ec8\u6b62!");
        }
    }
}

