package com.walker.tcp;

/**
 * 业务处理回调接口定义
 * @author 时克英
 * @date 2018-08-17
 *
 */
public interface ActionCallable {

	/**
	 * 系统接收到客户端请求后，回调该方法处理业务逻辑
	 * @param request
	 * @return
	 * @throws ActionCallException
	 */
	Response<?> action(Request<?> request) throws ActionCallException;
	
//	/**
//	 * 服务端下发指令后，系统会收到客户端确认回应，系统会自动调用该通知用于业务处理状态信息
//	 * @param request
//	 * @throws ActionCallException
//	 */
//	void orderDoneNotify(Request request) throws ActionCallException;
	
	/**
	 * 返回关联的请求协议，如：AP00
	 * @return
	 */
	String getRequestProtocol();
	
	/**
	 * 返回对应class名称（界面使用）
	 * @return
	 */
	String getClassName();
	
	/**
	 * 返回类的注释描述（界面使用）
	 * @return
	 */
	String getSummary();
	
	public static final String ERR_NOT_FOUND = "未找到任何配置的ActionCallable实例，tcp业务无法继续处理!";
}
