package com.walker.tcp;

public interface Connection {

	/**
	 * 通道ID，这个是java系统连接通道提供的全局唯一<code>ChannelId</code>
	 * @return
	 */
	String getId();

	/**
	 * 连接名称，这个也是系统唯一的，通常由业务定义或者绑定。如：卡号、设备终端IMEI等
	 * @return
	 */
	String getName();

	void setName(String name);

	long getCreateTimeMills();

	boolean supportLongConnection();

	/**
	 * 如果是长连接模式，返回该连接是否被业务认证。如果未认证就无法使用
	 * @return
	 */
	boolean isAuthenticated();

	/**
	 * 当前是否空闲
	 * @return
	 */
	boolean isIdle();

	Request<?> read();

	void write(Response<?> response);

	/**
	 * 服务端强制断开连接
	 */
	void disconnect();

	/**
	 * 获得该连接对应的引擎ID，通常一个项目中可能存在多种服务，每个服务对应一个服务引擎。</p>
	 * 如：一个TCP监听1010端口，另外一个服务监听2020端口等。</p>
	 * 如果系统只有一个监听服务，默认engineId = 0
	 * @return
	 */
	int getEngineId();

	/**
	 * 返回连接最后一次活动时间
	 * @return
	 */
	long getLastTime();

	/**
	 * 连接绑定业务标识，如：设备ID等</p>
	 * 绑定后，连接就被认证，后续可以使用了
	 */
	void bindName(String name);

	/**
	 * 长连接，判断是否连接状态
	 * @return
	 */
	boolean isConnected() ;

	ProtocolResolver getProtocolResolver();

	/**
	 * 设置报文解析器对象。对于一个连接会关联一个解析器以方便在request和response中使用
	 * @param resolver
	 */
	void setProtocolResolver(ProtocolResolver resolver);

	/**
	 * 获取该连接对象绑定的主机信息，在集群环境中，需要标记连接对应主机。
	 * <p>目前在聊天模块中，多主机部署通过消息方式推送，主机信息是队列的一部分，通过对方连接的主机知道消息如何被路由接收。</p>
	 * @return
	 * @date 2023-09-19
	 */
	String getConnectionHost();

	void setConnectionHost(String connectionHost);

    int getAlreadyLogin();
}
