package com.walker.tcp;

import java.util.List;

/**
 * 连接缓存定义，该接口为了集群扩展。
 * <pre>
 *     1) 在负载模式中，连接信息会被存储到Redis中。
 * </pre>
 * @author 时克英
 * @date 2023-09-19
 * @date 2023-09-25 连接信息不能直接缓存，因为涉及到netty链路信息，因此只能把链接基本信息缓存，这个需要通过<code>ConnectionManager</code>实现。
 */
public interface ConnectionCache {

    /**
     * 保存连接到缓存
     * @param connection
     */
    void putConnection(Connection connection);

    /**
     * 根据通道ID，删除连接对象。
     * @param id
     */
    void removeConnection(String id);

    void removeConnection(String id, Connection connection);

    /**
     * 更新连接信息
     * @param connection
     */
    void updateConnection(Connection connection);

    /**
     * 根据通道ID，获取连接对象。
     * @param id
     * @return
     */
    Connection getConnection(String id);

    /**
     * 根据通道绑定的用户名称，获得连接对象。
     * @param name
     * @return
     */
    Connection getConnectionByName(String name);

    /**
     * 根据连接绑定名称，查找对应通道ID
     * @param name
     * @return
     */
    String getIdByName(String name);

    /**
     * 返回所有链接集合。
     * <p>该方法在 redis 实现时，会设置最大返回数量。</p>
     * @return
     */
    List<Connection> getAllConnectionList();

    /**
     * 根据引擎ID，返回对应连接集合。
     * @param engineId
     * @return
     */
    List<Connection> getAllConnectionListBy(int engineId);
}
