package com.walker.tcp;

public interface ConnectionCallback {

    /**
     * 当通道空闲时触发该方法。
     * @param connection
     * @date 2023-08-24
     */
    void onIdle(Connection connection);

    /**
     * 当连接成功，并响应到客户端之后，触发回调方法。
     * <p>1、例如可以在连接成功后，给用户推送机器人消息等。</p>
     * @param connection
     * @date 2023-08-26
     */
    void onAfterLogin(Connection connection);
}
