package com.walker.tcp;

/**
 * 定义在通信过程中，上下文信息。
 * @author 时克英
 * @date 2018-10-25
 *
 */
public interface Context {

	/**
	 * 返回当前请求数据
	 * @return
	 */
	Request<?> getCurrentData();
	
	/**
	 * 返回上一次请求数据
	 * @return
	 */
	Request<?> getPreviousData();
	
	/**
	 * 返回这次接收数据距离上次的时间（毫秒值）
	 * @return
	 */
	long getPreviousTimeSpan();
	
}
