package com.walker.tcp;

/**
 * 协议解析器定义
 * @author 时克英
 * @date 2018-11-23
 *
 */
public interface ProtocolResolver<T> {

//	/**
//	 * 返回解析器唯一ID，在request中需要使用id来查找解析器
//	 * @return
//	 */
//	int getId();
	
	/**
	 * 解析器名字
	 * @return
	 */
	String getName();
	
	/**
	 * 根据输入数据内容，返回协议编号
	 * @param data 原始消息内容
	 * @return
	 * @exception ProtocolException 会抛出未找到协议编号异常
	 */
//	String getProtocolNum(String data, int size) throws ProtocolException;
	String getProtocolNum(T data, int size) throws ProtocolException;
	
	/**
	 * 返回该协议的特征，例如：有些设备通信数据包开头以IW标记，这个就是特征。有些可能没有
	 * @return
	 */
//	String getProtocolFeature();
	Object getProtocolFeature();
	
	/**
	 * 返回数据协议的结尾符号，大多数以\r\n结尾，也有#结尾等
	 * @return
	 */
	String getDelimiter();
	
	/**
	 * 顺序号来排序，同时也当做唯一ID使用
	 * @return
	 */
	int getOrder();
	
	/**
	 * 是否需要再根据特征（前缀）来判断解析器类型。</p>
	 * 目前多个解析情况下，主要根据分隔符来确定解析器，但如果有多个解析器分隔符一样，就要再确定前缀特征才能匹配。
	 * 因此该方法设置解析器是否需要继续根据特征来判断，查找<code>ProtocolResolverPostProcessor</code>
	 * @return
	 */
	boolean isRequireFeatureResolve();
	
	/**
	 * 获得一个心跳响应对象
	 * @return
	 */
	Response<?> getHeartBeatResponse();
	
	/**
	 * 返回认证信息，通常第一次连接平台后，终端会发送认证请求。该方法返回认证后的用户信息，如：用户编号、设备编号等。
	 * @param request
	 * @return
	 */
	String getAuthenticateInfo(Request<?> request) throws AuthenticateException;
	
	/**
	 * 是否支持未注册设备连接服务，如果允许（true）那么系统中未定义的设备也可以获得认证并提交数据。
	 * @return
	 */
	boolean isPermitNotRegisterConnect();
	
	public static final String ERR_PROTOCOL_SIZE = "不符合报文长度";
	public static final String ERR_PROTOCOL_FEATURE = "不符合报文特征";
	
	public static final String ERR_NOFOUND = "系统未配置任何ProtocolResolver对象，无法解析报文";
	public static final String ERR_NO_FEATURE = "报文解析需要前缀特征，但该解析器未定义特征。";
	
	/**
	 * 仅仅依靠报文特征来获得一个完整报文，如果是返回<code>true</code></p>
	 * 有些设备发送的数据，为了简单不会使用长报文，而且不需要处理报文合并问题，一次一个短报文，
	 * 这样就只需要根据特征区分设备信息，而且通常数据长度也在报文中，例如：充电桩。
	 * @return
	 * @author 时克英
	 * @date 2020-08-21
	 */
	boolean isOnlyMatchFeature();
}
