package com.walker.tcp;

import com.walker.tcp.handler.AbstractStringHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

import java.util.Map;
import java.util.TreeMap;

/**
 * 集中存放系统定义的所有<code>Request</code>对象。</p>
 * @author 时克英
 * @date 2018-11-27
 *
 */
public class RequestPostProcessor implements BeanPostProcessor {

	private final transient Logger logger = LoggerFactory.getLogger(getClass());

	private static final Map<String, String> reference = new TreeMap<String, String>();

//	private static List<ProtocolResolver> cacheList =null;

//	private final InnerComparator comparator = new InnerComparator();

	@Override
	public Object postProcessAfterInitialization(Object bean, String beanName)
			throws BeansException {
		if(ServerHandler.class.isAssignableFrom(bean.getClass())){
			AbstractStringHandler pr = (AbstractStringHandler)bean;
			reference.putAll(pr.getMapper());
			logger.info("找到了一个ServerHandler：" + pr.getClass().getName());
		}

		return bean;
	}

	/**
	 * 根据数据协议编号，查找要处理该业务的action实例。</p>
	 *
	 * @param protocolNum
	 * @return
	 */
	public static final String getAction(String protocolNum){
		if(reference.size() == 0){
			throw new IllegalArgumentException("未配置任何request对象");
		}

		String action = reference.get(protocolNum);
		if(action == null){
			throw new IllegalArgumentException("未找到定义的request实现类，protocolNum = " + protocolNum);
		}
		return action;
	}

	/**
	 * 返回所有requestNum和action类名称对应关系
	 * @return
	 */
	public static final Map<String, String> getActionList(){
		return reference;
	}
}
