package com.walker.tcp;

import java.io.Serializable;

/**
 * 定义TCP通信中响应规范
 * @author 时克英
 * @date 2018-08-20
 *
 */
public interface Response<T> extends Serializable {

	/**
	 * 返回消息主题名称，在集群模式中，需要该属性区分队列名称。
	 * @return
	 * @date 2023-09-25
	 */
	String getTopic();

	/**
	 * 把响应对象转换成可传输的内容。
	 * @return
	 */
	T toData();

	/**
	 * 返回业务对应的请求终端ID，如：设备唯一ID等
	 * @return
	 */
	String getName();

	/**
	 * 返回业务协议中，约定的协议名称，即：接口名称，如：001代表登录请求，002代表登录响应
	 * @return
	 */
	String getProtocolNum();

	/**
	 * 设置商业内容
	 * @param content
	 */
	void setBusinessContent(T content);

	String getMessageId();

	void setName(String name);

	/**
	 * 返回响应数据的分隔符，例如：# 或者 \r\n
	 * @return
	 */
	String getDelimiter();

}
