package com.walker.tcp;

import io.netty.channel.ChannelHandlerContext;

/**
 * 系统抽象的TCP通信handler接口，用于隔离第三方组件的接口方法。
 * @author 时克英
 *
 */
public interface ServerHandler<T> {

	/**
	 * 当客户端连接上时，回调改方法
	 * @param id 连接通道全局唯一ID，由系统生成
	 * @throws Exception
	 */
	void onConnected(String id) throws Exception;
	
	void onDisConnected(String id) throws Exception;
	
	void onRead(Connection conn, T msg) throws Exception;
	
	/**
	 * 读完请求数据后的方法调用
	 * @param msg 消息体
	 * @param id 通道ID
	 * @throws Exception
	 */
	void onReadComplete(T msg, String id, ChannelHandlerContext ctx) throws Exception;
	
	void onException(Throwable cause) throws Exception;
	
	int getEngineId();
	
	ConnectionManager getConnectionManager();
	
	/**
	 * 设置选项：接收到客户端空数据时，是否断开连接，默认：false</p>
	 * 因为存在情况，有些终端在关机时会向服务端发送空数据。
	 * @param result
	 */
	void setEmptyMsgDisconnect(boolean result);
}
