package com.walker.tcp.connect;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.walker.tcp.Response;

public class LongConnection extends AbstractConnection {

	public LongConnection(){}

	public LongConnection(String id){
		super(id);
	}

	@JsonIgnore
	@Override
	public boolean supportLongConnection() {
		return true;
	}

	@JsonIgnore
	@Override
	public void write(Response<?> response) {
		super.write(response);
		this.setLastTime(System.currentTimeMillis());
	}
}
