package com.walker.tcp.data;

import com.walker.tcp.Request;

public abstract class BaseRequest<T> implements Request<T> {

	/**
	 * 
	 */
	private static final long serialVersionUID = 5914600835720765181L;

	long timeStamp = 0;
	
	private String messageId;
	
	private String name;
	
	private String sessionId;
	
	@Override
	public String getSessionId() {
		return sessionId;
	}

	public void setSessionId(String sessionId) {
		this.sessionId = sessionId;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	@Override
	public String getName() {
		return name;
	}

	@Override
	public long getTimeStamp() {
		return timeStamp;
	}

	@Override
	public String getProtocolNum() {
		return null;
	}

	@Override
	public String getBusinessContent() {
		return null;
	}
	
	@Override
	public String getMessageId() {
		return messageId;
	}

	public void setMessageId(String messageId) {
		this.messageId = messageId;
	}
	
	@Override
	public String toString(){
		return new StringBuilder().append("[ time=").append(this.timeStamp)
				.append(", name=").append(getName())
				.append(", protocol=").append(getProtocolNum())
				.append(", content=").append(getBusinessContent())
				.append(", messageId=").append(getMessageId())
				.append(" ]").toString();
	}
	
	@Override
	public boolean isRequireResponse() {
		return true;
	}
	
//	private ProtocolResolver protocolResolver;
//	public ProtocolResolver getProtocolResolver() {
//		return protocolResolver;
//	}
//	public void setProtocolResolver(ProtocolResolver protocolResolver) {
//		this.protocolResolver = protocolResolver;
//	}
	
	private int protocolResolverId = -1;

	@Override
	public int getProtocolResolverId() {
		return protocolResolverId;
	}

	@Override
	public void setProtocolResolverId(int protocolResolverId) {
		this.protocolResolverId = protocolResolverId;
	}
	
}
