package com.walker.tcp.data;

import com.walker.tcp.Response;

public abstract class BaseResponse<T> implements Response<T> {

	/**
	 *
	 */
	private static final long serialVersionUID = -8981468082146241607L;

	private String messageId;

	private String name;

	private String topic;

	// 2023-09-28 添加属性，为了Json可序列化。
	private String protocolNum;
	private String delimiter;

	@Override
	public String getDelimiter() {
		return delimiter;
	}

	public void setDelimiter(String delimiter) {
		this.delimiter = delimiter;
	}

	public String getTopic(){
		return this.topic;
	}

	@Override
	public String getName() {
		return name;
	}

	@Override
	public String getProtocolNum() {
		return this.protocolNum;
	}

	public void setProtocolNum(String protocolNum) {
		this.protocolNum = protocolNum;
	}

	/**
	 * 该方法暂时没有使用
	 */
	@Override
	public void setBusinessContent(T content) {

	}

	public void setTopic(String topic){
		this.topic = topic;
	}

	@Override
	public void setName(String name) {
		this.name = name;
	}

	@Override
	public String getMessageId() {
		return messageId;
	}

	public void setMessageId(String messageId) {
		this.messageId = messageId;
	}

	@Override
	public String toString(){
		return new StringBuilder().append("[ messageId=").append(this.messageId)
				.append(", name=").append(getName())
				.append(", protocol=").append(getProtocolNum())
				.append(", data=").append(this.toData())
				.append(" ]").toString();
	}
}
