package com.walker.tcp.lb;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.walker.tcp.Response;
import com.walker.tcp.connect.LongConnection;

/**
 * 长连接元数据对象。
 * <pre>
 *     1) 该对象描述了每个物理连接基本情况，全局存在。
 *     2) 在集群环境中使用，会集中存储到 Redis 中。
 *     3) 当物理连接被删除时，该描述缓存也会被一同删除。
 *     4) 当该对象缓存存在时，我们认为物理连接也是存在的。
 * </pre>
 * @author 时克英
 * @date 2023-09-25
 */
public class LongConnectionMeta extends LongConnection {

    public LongConnectionMeta(){}

    public LongConnectionMeta(String id) {
        super(id);
    }

    @JsonIgnore
    @Override
    public boolean supportLongConnection() {
        return true;
    }

    /**
     * 只要存在该对象，说明物理连接还在。
     * @return
     */
    @JsonIgnore
    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public void write(Response<?> response) {
        if(this.responseWriter == null){
            throw new IllegalArgumentException("responseWriter未设置");
        }
        super.write(response);
        this.responseWriter.write(ResponseWriter.TYPE_MQ, response, this.getConnectionHost(), this.getId());
        this.onWrite(response);
    }

    protected void onWrite(Response<?> response){
        logger.info("LongConnectionMeta.onWrite(res)");
    }

    public ResponseWriter getResponseWriter() {
        return responseWriter;
    }

    public void setResponseWriter(ResponseWriter responseWriter) {
        this.responseWriter = responseWriter;
    }

    @JsonIgnore
    private ResponseWriter responseWriter;
}
