package com.walker.tcp.lb;

import com.walker.infrastructure.utils.StringUtils;
import com.walker.support.redis.cache.RedisCacheProvider;
import com.walker.tcp.Constants;

/**
 * 连接元数据对象缓存定义。
 * <p>这仅仅是描述了连接基本信息，不是长连接本身！</p>
 * @author 时克英
 * @date 2023-09-25
 */
public class RedisConnectionMetaCache extends RedisCacheProvider<LongConnectionMeta> {

    public RedisConnectionMetaCache(){
        this.setUseRedis(true);
        this.setLoadPage(false);
    }

    public LongConnectionMeta getConnectionMeta(String id){
        return this.getCacheData(id);
    }

    public void removeConnectionMeta(String id){
        this.removeCacheData(id);
    }

    /**
     * 缓存一个连接元数据对象，默认：24小时候失效。
     * @param connectionMeta
     */
    public void putConnectionMeta(LongConnectionMeta connectionMeta){
//        this.putCacheData(this.getKey(connectionMeta.getConnectionHost(), connectionMeta.getId()), connectionMeta, expiredSeconds);
        this.putCacheData(connectionMeta.getId(), connectionMeta, expiredSeconds);
    }

    @Deprecated
    private String getKey(String connectionHost, String id){
        return new StringBuilder(connectionHost).append(StringUtils.SEPARATOR_COLON).append(id).toString();
    }

    @Override
    public String getProviderName() {
        return Constants.CACHE_NAME_CONNECTION_META;
    }

    @Override
    public Class<?> getProviderType() {
        return LongConnectionMeta.class;
    }

    public long getExpiredSeconds() {
        return expiredSeconds;
    }

    /**
     * 设置缓存失效时间，单位：秒，如果不设置默认：24小时
     * @param expiredSeconds
     */
    public void setExpiredSeconds(long expiredSeconds) {
        this.expiredSeconds = expiredSeconds;
    }

    private long expiredSeconds = 2 * 3600;
}
