package com.walker.tcp.littleD;

import com.walker.infrastructure.utils.StringUtils;
import com.walker.tcp.TcpRequest;

/**
 * 心跳请求定义
 * @author 时克英
 *
 */
@TcpRequest("AP03")
public class HeartBeatRequest extends AbstractRequest {

	/**
	 * 
	 */
	private static final long serialVersionUID = -8938345994050130677L;
	
	private String gsm = null;
	private String satelliteNum = null;
	private String power = null;

	public String getGsm() {
		return gsm;
	}

	public String getSatelliteNum() {
		return satelliteNum;
	}

	public String getPower() {
		return power;
	}

	@Override
	protected void translateBusiness(String business) {
		String[] data = business.substring(1).split(StringUtils.DEFAULT_SPLIT_SEPARATOR);
		gsm = data[0].substring(0, 3);
		satelliteNum = data[0].substring(3, 6);
		power = data[0].substring(6, 9);
	}

	public static void main(String[] args){
		HeartBeatRequest request = new HeartBeatRequest();
		request.fromSource("IWAP03,06000908000102,5555,30");
		System.out.println(request);
		System.out.println(request.getGsm());
		System.out.println(request.getSatelliteNum());
		System.out.println(request.getPower());
	}
	
}
