package com.walker.tcp.littleD;

import com.walker.infrastructure.utils.StringUtils;
import com.walker.tcp.AuthenticateException;
import com.walker.tcp.ProtocolException;
import com.walker.tcp.Request;
import com.walker.tcp.Response;
import com.walker.tcp.data.AbstractStringResponse;
import com.walker.tcp.protocol.StringProtocolResolver;

/**
 * 安全帽（小D智能定位终端）协议解析器实现。
 * @author 时克英
 * @date 2018-11-23
 *
 */
public class LittleDProtocolResolver extends StringProtocolResolver {

	public LittleDProtocolResolver(){
		this.setDelimiter(Constants.DATA_END_FLAG);
		this.setProtocolFeature(Constants.BODY_ID);
		this.setName("小D智能终端协议解析器");
		this.setOrder(1);
	}
	
	@Override
	protected String onResolve(String source, int size) throws ProtocolException {
		if(size < 6){
			throw new ProtocolException(ERR_PROTOCOL_SIZE);
		}
		
		if(!source.startsWith(this.getProtocolFeature().toString())){
			throw new ProtocolException(ERR_PROTOCOL_FEATURE);
		}
		return source.substring(2, 6);
	}

	@Override
	protected Response<?> doCreateOneResponse() {
		return new TestResponse();
	}

	private  class TestResponse extends AbstractStringResponse {

		/**
		 * 
		 */
		private static final long serialVersionUID = -7728231375789281173L;
		/**
		 * 
		 */
		private static final String TEST_PACKAGE = "0#";
		
		@Override
		public String toData() {
			/** 注意，这里心跳数据结尾可能会有多种分隔符，因为目前支持多种数据协议。
			 * 例如：0#,\r\n等，这样发送出去是会出错的，因此必须根据连接协议拼接相应的分隔符！
			 *  */
			return TEST_PACKAGE;
		}

		@Override
		public String getProtocolNum() {
			return null;
		}

		@Override
		public String getDelimiter() {
			return null;
		}
	}

	@Override
	public String getAuthenticateInfo(Request<?> request) throws AuthenticateException {
		if(request instanceof LoginRequest){
			String clientId = request.getName();
			if(StringUtils.isEmpty(clientId)){
				throw new AuthenticateException("请求信息中不存在设备ID号，无法认证");
			}
			
			if(!isPermitNotRegisterConnect() && !this.isRegistered(clientId)){
				throw new AuthenticateException("设备未在列表中注册，无法认证。clientId = " + clientId);
			}
			return clientId;
			
		} else {
			throw new AuthenticateException("connection通道认证失败，请求不是登录");
		}
	}
	
}
