package com.walker.tcp.netty;

import io.netty.channel.ChannelFactory;
import io.netty.util.internal.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 自定义<code>ChannelFactory</code>，通过更改里面的默认 ServerChannel 才能生成通道ID。
 * @author 时克英
 * @date 2023-09-29
 * @date 2023-10-14 自定义生成通道ID后，财政厅项目出现聊天消息的通道与登录不是一个，导致未认证<br>,
 * 目前还不清楚原因，所以代码回退了，仍使用netty默认值。
 */
@Deprecated
public class GenIdChannelFactory implements ChannelFactory<GenIdNioSocketChannel> {

//    private final GenIdNioSocketChannel socketChannel = new GenIdNioSocketChannel();
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public GenIdNioSocketChannel newChannel() {
//        return this.socketChannel;
        logger.debug("生成一个：GenIdNioSocketChannel 对象");
        return new GenIdNioSocketChannel();
    }

    @Override
    public String toString() {
        return StringUtil.simpleClassName(GenIdChannelFactory.class) + '(' + StringUtil.simpleClassName(GenIdNioSocketChannel.class.getDeclaringClass()) + ".class)";
    }
}
